package org.ow2.petals.bc.sftp.steps

import org.apache.sshd.SshServer;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.FileSystemFactory;
import org.apache.sshd.server.FileSystemView;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.SshFile;
import org.apache.sshd.server.filesystem.NativeFileSystemFactory;
import org.apache.sshd.server.filesystem.NativeFileSystemView;
import org.apache.sshd.server.filesystem.NativeSshFile;
import org.apache.sshd.server.keyprovider.PEMGeneratorHostKeyProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.sftp.SftpSubsystem;
import org.ow2.petals.groovycommons.util.PlatformDependantObject;
import org.ow2.petals.groovycommons.util.LinuxProcess;
import org.ow2.petals.groovycommons.util.MavenProject;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;

import static org.jbehave.core.io.CodeLocations.*;


class SshdServer {

    SshServer sshServer;
    String sshdHost = "localhost";
    int sshdPort = 8022;
    File workingDir = FileSystemHelper.createTempDir("sftp-workingDir");
    File hostKeyPairDir = FileSystemHelper.createTempDir("sftp-hostKeyPairDir");
    Map<String, String> usersAndPasswords = new HashMap<String, String>();

    class SpecificUserDirFileSystemView implements FileSystemView {

        private final String userName;

        SpecificUserDirFileSystemView(String userName) {
            this.userName = userName;
        }

        public SshFile getFile(SshFile baseDir, java.lang.String file) {
            String physicalName = NativeSshFile.getPhysicalName("/",
            		SshdServer.this.workingDir.getAbsolutePath(), file, false);
            File fileObj = new File(physicalName);
            return new NativeSshFile(physicalName, fileObj, userName);
        }

        public SshFile getFile(String file) {
            return SpecificUserDirFileSystemView.this.getFile(
            new NativeSshFile(SshdServer.this.workingDir.getAbsolutePath(), SshdServer.this.workingDir, this.userName), file);
        }
    }

    class SpecificUserDirFileSystemFactory implements FileSystemFactory {

        FileSystemView createFileSystemView(Session session) {
            return new SpecificUserDirFileSystemView(session.getUsername());
        }
    }

    def start() {
        this.sshServer = SshServer.setUpDefaultServer();
        this.sshServer.setPort(this.sshdPort);
        this.sshServer.setHost(this.sshdHost);
        this.sshServer.setKeyPairProvider(new SimpleGeneratorHostKeyProvider());
        this.sshServer.setSubsystemFactories(Arrays.<NamedFactory<Command>>asList(new SftpSubsystem.Factory()));
        this.sshServer.setFileSystemFactory(new SpecificUserDirFileSystemFactory());
        this.sshServer.setPasswordAuthenticator(new PasswordAuthenticator() {

                    @Override
                    public boolean authenticate(String username, String password, ServerSession session) {
                        if (!this.usersAndPasswords.containsKey(username)) return false;
                        if (!this.usersAndPasswords.get(username).equals(password)) return false;
                        return true;
                    }
                });
        this.sshServer.start();
        String workingDirPath = this.workingDir.getAbsolutePath();
        println "-- Sshd server started with working dir '${workingDirPath}' --";
    }

    def stop() {
        println "-- Sshd server stop --";
    	this.sshServer.stop(true);
    }



    def reset() {
        FileSystemHelper.cleanDirectory(this.workingDir);
        this.usersAndPasswords.clear();
        println "-- Sshd server reset --";
    }

    def addUser(String user, String password) {
    	this.usersAndPasswords.put(user, password);
    }
}
