Story: identify sftp provider begin step 

Scenario: thanks to MONIT log record

Given the ESB only composed of <nodeHost> known as <nodeName>
And MONIT enabled on <nodeName>

Given a sftp server installed on the port <sftpPort> of <sftpHost> 
And an account <user> / <password> on this sftp server

Given a file <fileName> available on this sftp server

Given a sftp component <componentName> configured on <nodeName>
imports this external server as an internal service
<interfaceName>,<serviceName>,<endpointName>

When a request is received by this internal service with <operationName>,
the flow instance id <flowInstanceId> and the previous step id <previousStepId>

Then a first MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:

| key                   | matcher | value
| traceCode             | equals  | provideFlowStepBegin                                         |                                                                           
| flowInstanceId        | equals  | flowInstanceId |                                                                                                                         
| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                           
| flowStepInterfaceName | equals  | interfaceName                                                |                                                                             
| flowStepServiceName   | equals  |  serviceName                                                |                                                                             
| flowStepEndpointName  | equals  |  endpointName                                               |                                                                             
| flowStepOperationName | equals  |  operationName                                              |                                                                             
| flowPreviousStepId    | equals  |  previousStepId |

And later, an other MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:

|key            | matcher | value              |
|traceCode      | equals  | provideFlowStepEnd |
|flowInstanceId | equals  | flowInstanceId     |
|flowStepId     | regex  | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |

And flowStepId of first record must be equal to flowStepId of the other record
And flowInstanceId of first record must be equal to flowInstanceId of the other record

Examples:
| nodeHost  | nodeName | sftpHost   | sftpPort | user  | password  | fileName  | interfaceName            | serviceName                | endpointName  | operationName                                        | componentName  | flowInstanceId                       | previousStepId |
| localhost | node1    | localhost	| 8022 | user1 | password1 | test1.txt | {http://pns1/}interfaceName1 | {http://pns1/}serviceName1 | endpointName1 | {http://petals.ow2.org/components/sftp/version-1}get | petals-bc-sftp | ec7507e0-f01f-11e0-8411-0024e8b3e525 | ps7507e0-f01f-11e0-8411-0024e8b3e525 |
| localhost | node1    | localhost	| 8022 | user1 | password1 | test1.txt | {http://pns1/}interfaceName1 | {http://pns1/}serviceName1 | endpointName1 | {http://petals.ow2.org/components/sftp/version-1}del | petals-bc-sftp | ec7507e0-f01f-11e0-8411-0024e8b3e525 | ps7507e0-f01f-11e0-8411-0024e8b3e525 |




