/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SourceHelper {
    private SourceHelper() {
    }

    public static InputSource convertDOMSource2InputSource(DOMSource domSource) throws XmlException {
        InputSource source = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(os);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(domSource, streamResult);
            os.flush();
            os.close();
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            StreamSource attach = new StreamSource(is);
            source = SAXSource.sourceToInputSource(attach);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new XmlException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new XmlException(e);
        }
        catch (TransformerException e) {
            throw new XmlException(e);
        }
        return source;
    }

    public static DOMSource convertInputSource2DOMSource(InputSource inputSource) throws XmlException {
        DOMSource res = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder db = factory.newDocumentBuilder();
            Document document = db.parse(inputSource);
            res = new DOMSource(document);
        }
        catch (ParserConfigurationException e) {
            throw new XmlException(e);
        }
        catch (SAXException e) {
            throw new XmlException(e);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
        return res;
    }
}

