/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.uri;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class UriManager {
    public static URI urlToUri(URL url) {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (Exception e) {
            try {
                uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            }
            catch (Exception e1) {
                throw new IllegalArgumentException("Broken URL: " + url);
            }
        }
        uri = uri.normalize();
        return uri;
    }

    public static URI urlToUri(String urlAsString) {
        try {
            URL url = new URL(urlAsString);
            return UriManager.urlToUri(url);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Broken URL: " + urlAsString);
        }
    }

    public static URI filePathToUri(String path) {
        URI uri;
        try {
            path = path.replaceAll("\\\\", "/");
            uri = new URI(path);
        }
        catch (URISyntaxException e1) {
            uri = new File(path).toURI();
            uri.normalize();
        }
        return uri;
    }

    public static URL filePathToUrl(String path) {
        URL url;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException e1) {
            try {
                URI uri = UriManager.filePathToUri(path);
                url = uri.toURL();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Broken URL: " + path);
            }
        }
        return url;
    }

    public static URI buildNewURI(URI referenceUri, String uriSuffix) throws Exception {
        if (uriSuffix == null) {
            throw new NullPointerException("The URI suffix cannot be null.");
        }
        URI importUri = null;
        try {
            importUri = UriManager.urlToUri(new URL(uriSuffix));
        }
        catch (Exception e) {
            try {
                importUri = referenceUri.resolve(new URI(null, uriSuffix, null));
            }
            catch (Exception e2) {
                String msg = "An URI could not be built from the URI " + referenceUri.toString() + " and the suffix " + uriSuffix + ".";
                throw new Exception(msg, e2);
            }
        }
        return importUri.normalize();
    }

    public static boolean isAbsoluteUri(String uriAsString) {
        boolean result;
        try {
            URI uri = UriManager.urlToUri(uriAsString);
            result = uri.isAbsolute();
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

