/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap;

import java.io.File;
import java.util.Iterator;
import java.util.logging.Level;
import javax.jbi.JBIException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.phaseresolver.PhaseException;
import org.apache.axis2.phaseresolver.PhaseHolder;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSListener;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.binding.soap.SoapSUManager;
import org.ow2.petals.binding.soap.listener.incoming.PetalsReceiver;
import org.ow2.petals.binding.soap.listener.incoming.SoapExternalListenerManager;
import org.ow2.petals.binding.soap.util.Marshaller;
import org.ow2.petals.component.framework.bc.AbstractBindingComponent;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;

public class SoapComponent
extends AbstractBindingComponent {
    protected SoapExternalListenerManager externalListenerManager;
    protected SoapComponentContext soapContext;
    private PetalsReceiver petalsReceiver;
    private ConfigurationContext axisConfigurationContext = null;

    private void createJMSTransporter() throws AxisFault {
        TransportInDescription jmsTransportDescription = new TransportInDescription("jms");
        jmsTransportDescription.setReceiver((TransportListener)new JMSListener());
        this.axisConfigurationContext.getAxisConfiguration().addTransportIn(jmsTransportDescription);
        String jndiInitialFactory = this.getComponentExtensions().get((Object)"java-naming-factory-initial");
        String jndiProviderUrl = this.getComponentExtensions().get((Object)"java-naming-provider-url");
        String confacJndiName = this.getComponentExtensions().get((Object)"jms-connection-factory-jndiname");
        if (jndiInitialFactory != null && jndiProviderUrl != null && confacJndiName != null && jndiInitialFactory.length() > 0 && jndiProviderUrl.length() > 0 && confacJndiName.length() > 0) {
            this.soapContext.setJmsJndiInitialFactory(jndiInitialFactory);
            this.soapContext.setJmsJndiProviderUrl(jndiProviderUrl);
            this.soapContext.setJmsConnectionFactoryName(confacJndiName);
            this.getLogger().info("Create the default JMS connection factory ('default'):");
            this.getLogger().info("\tjava-naming-factory-initial: " + jndiInitialFactory);
            this.getLogger().info("\tjava-naming-provider-url: " + jndiProviderUrl);
            this.getLogger().info("\tjms-connection-factory-jndiname: " + confacJndiName);
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            OMElement initialContextFactory = omFactory.createOMElement(new QName("parameter"));
            initialContextFactory.addAttribute("name", "java.naming.factory.initial", null);
            initialContextFactory.setText(jndiInitialFactory);
            OMElement providerUrl = omFactory.createOMElement(new QName("parameter"));
            providerUrl.addAttribute("name", "java.naming.provider.url", null);
            providerUrl.setText(jndiProviderUrl);
            OMElement connectionFactoryName = omFactory.createOMElement(new QName("parameter"));
            connectionFactoryName.addAttribute("name", "transport.jms.ConnectionFactoryJNDIName", null);
            connectionFactoryName.setText(confacJndiName);
            OMElement defaultConnectionFactory = omFactory.createOMElement(new QName("parameter"));
            defaultConnectionFactory.addChild((OMNode)initialContextFactory);
            defaultConnectionFactory.addChild((OMNode)providerUrl);
            defaultConnectionFactory.addChild((OMNode)connectionFactoryName);
            jmsTransportDescription.addParameter(new Parameter("default", (Object)defaultConnectionFactory));
        } else {
            this.getLogger().info("The JMS transport layer configuration is not complete. It is disabled.");
        }
    }

    @Override
    protected AbstractServiceUnitManager createServiceUnitManager() {
        return new SoapSUManager(this);
    }

    @Override
    protected void doInit() throws JBIException {
        this.soapContext = new SoapComponentContext(this.getContext(), this.getComponentConfiguration(), this.getLogger());
        File axis2File = new File(this.getContext().getWorkspaceRoot(), "axis2.xml");
        if (!axis2File.exists()) {
            throw new JBIException("Can not get axis2 configuration file");
        }
        this.getLogger().fine("Creating Axis configuration context...");
        try {
            this.axisConfigurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.getContext().getWorkspaceRoot(), (String)axis2File.getAbsolutePath());
            this.createJMSTransporter();
            this.soapContext.setAxis2ConfigurationContext(this.axisConfigurationContext);
            this.getLogger().fine("Axis configuration context set.");
        }
        catch (AxisFault e) {
            this.getLogger().log(Level.SEVERE, e.getMessage());
            throw new JBIException("Can not initialize SOAP BC", (Throwable)e);
        }
        this.petalsReceiver = new PetalsReceiver(this, this.getChannel(), this.getLogger());
        this.externalListenerManager = new SoapExternalListenerManager(this, this.getChannel(), (AbstractServiceUnitManager)this.getServiceUnitManager(), this.soapContext, this.petalsReceiver, this.getLogger());
        this.engageModulesHandlers(this.axisConfigurationContext.getAxisConfiguration());
        ((SoapSUManager)this.getServiceUnitManager()).init(this.soapContext, this.getContext(), this.externalListenerManager.getSoapServerConfig(), this.petalsReceiver, this.getLogger());
    }

    @Override
    public void doStart() throws JBIException {
        try {
            AxisConfiguration axisConfiguration = this.soapContext.getAxis2ConfigurationContext().getAxisConfiguration();
            this.externalListenerManager.start(axisConfiguration);
            try {
                axisConfiguration.getTransportIn("jms").getReceiver().start();
            }
            catch (AxisJMSException e) {
                this.getLogger().info("The JMS Transport is not available. SOAP over JMS is not available.");
                this.getLogger().log(Level.FINE, "Unable to start the JMS Transport (" + e.getMessage() + "). SOAP over JMS is not available.", e);
            }
        }
        catch (AxisFault e) {
            this.getLogger().severe(e.getMessage());
            throw new JBIException((Throwable)e);
        }
    }

    @Override
    public void doStop() throws JBIException {
        try {
            this.externalListenerManager.stop();
            this.soapContext.getAxis2ConfigurationContext().getAxisConfiguration().getTransportIn("jms").getReceiver().stop();
        }
        catch (AxisFault e) {
            this.getLogger().severe(e.getMessage());
            throw new JBIException((Throwable)e);
        }
    }

    @Override
    protected void doShutdown() throws JBIException {
        try {
            this.axisConfigurationContext.terminate();
            this.externalListenerManager.shutdown();
            Marshaller.close();
        }
        catch (AxisFault e) {
            throw new JBIException("Error stopping the soap engine: " + e.getMessage(), (Throwable)e);
        }
    }

    private void engageModuleHandlersIntoPhases(AxisModule module, AxisConfiguration axisConfiguration) throws PhaseException {
        Flow moduleFlow = null;
        PhaseHolder phaseHolder = null;
        this.getLogger().fine("Engaging module " + module.getName() + " in flows");
        for (int type = 1; type <= 4; ++type) {
            if (type == 1) {
                phaseHolder = new PhaseHolder(axisConfiguration.getInFlowPhases());
                moduleFlow = module.getInFlow();
            } else if (type == 2) {
                phaseHolder = new PhaseHolder(axisConfiguration.getOutFlowPhases());
                moduleFlow = module.getOutFlow();
            } else if (type == 3) {
                phaseHolder = new PhaseHolder(axisConfiguration.getInFaultFlowPhases());
                moduleFlow = module.getFaultInFlow();
            } else if (type == 4) {
                phaseHolder = new PhaseHolder(axisConfiguration.getOutFaultFlowPhases());
                moduleFlow = module.getFaultOutFlow();
            }
            if (moduleFlow == null || phaseHolder == null) continue;
            for (int j = 0; j < moduleFlow.getHandlerCount(); ++j) {
                phaseHolder.addHandler(moduleFlow.getHandler(j));
            }
        }
    }

    private void engageModulesHandlers(AxisConfiguration axisConfiguration) throws JBIException {
        Iterator modules = axisConfiguration.getEngagedModules().iterator();
        while (modules.hasNext()) {
            try {
                this.engageModuleHandlersIntoPhases((AxisModule)modules.next(), axisConfiguration);
            }
            catch (PhaseException e) {
                this.getLogger().log(Level.SEVERE, e.getMessage());
                throw new JBIException("Can not initialize SOAP BC", (Throwable)e);
            }
        }
        this.getLogger().fine("Axis modules flows added");
    }

    public SoapExternalListenerManager getExternalListenerManager() {
        return this.externalListenerManager;
    }

    public SoapComponentContext getSoapContext() {
        return this.soapContext;
    }
}

