/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.addressing;

import org.ow2.petals.binding.soap.addressing.Addressing;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;

public class WSAHelper {
    public static final Addressing getAddressing(ConfigurationExtensions extensions) {
        if (extensions == null) {
            return null;
        }
        Addressing addressing = new Addressing();
        addressing.setFrom(SUPropertiesHelper.getWSAFrom(extensions));
        addressing.setTo(SUPropertiesHelper.getWSATo(extensions));
        if (addressing.getTo() == null) {
            addressing.setTo(SUPropertiesHelper.getAddress(extensions));
        }
        addressing.setFaultTo(SUPropertiesHelper.getWSAFaultTo(extensions));
        addressing.setReplyTo(SUPropertiesHelper.getWSAReplyTo(extensions));
        return addressing;
    }

    public static Addressing getAddressing(String address) {
        if (address != null && !address.isEmpty()) {
            Addressing addressing = new Addressing();
            addressing.setTo(address);
            return addressing;
        }
        return null;
    }

    public static final Addressing merge(Addressing wsAddressing, Addressing suAddressing) {
        Addressing result = new Addressing();
        if (wsAddressing != null && wsAddressing.getTo() != null && wsAddressing.getTo().length() != 0) {
            result.setTo(wsAddressing.getTo());
        }
        if (suAddressing != null) {
            if (result.getTo() == null && suAddressing.getTo() != null && suAddressing.getTo().length() != 0) {
                result.setTo(suAddressing.getTo());
            }
            if (result.getFaultTo() == null && suAddressing.getFaultTo() != null && suAddressing.getFaultTo().length() != 0) {
                result.setFaultTo(suAddressing.getFaultTo());
            }
            if (result.getFrom() == null && suAddressing.getFrom() != null && suAddressing.getFrom().length() != 0) {
                result.setFrom(suAddressing.getFrom());
            }
            if (result.getMessageId() == null && suAddressing.getMessageId() != null && suAddressing.getMessageId().length() != 0) {
                result.setMessageId(suAddressing.getMessageId());
            }
            if (result.getReplyTo() == null && suAddressing.getReplyTo() != null && suAddressing.getReplyTo().length() != 0) {
                result.setReplyTo(suAddressing.getReplyTo());
            }
        }
        return result;
    }
}

