/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.MessageReceiver;
import org.ow2.petals.binding.soap.listener.incoming.PetalsAxisService;
import org.ow2.petals.binding.soap.listener.incoming.PetalsReceiver;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;

public class PetalsDispatcher
extends AbstractDispatcher
implements AddressingConstants {
    public static final String NAME = "PetalsDispatcher";
    private static final long serialVersionUID = 10983L;
    protected AbstractServiceUnitManager bindingSUM;
    protected DeliveryChannel channel;
    protected AbstractComponent component;
    protected AxisOperation jbiOperation;
    protected AxisOperation notifyOperation;
    protected PetalsReceiver petalsReceiver;
    protected AxisService jbiService;
    protected Logger log = null;

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        return this.jbiOperation;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        AxisService axisService = null;
        String serviceName = null;
        EndpointReference toEPR = messageContext.getTo();
        this.log.log(Level.FINE, "PetalsDispatcher - Checking for Service using target endpoint address : " + toEPR.getAddress());
        String filePart = toEPR.getAddress();
        serviceName = this.extractWebServiceName(filePart);
        axisService = messageContext.getConfigurationContext().getAxisConfiguration().getService(serviceName);
        if (axisService == null) {
            throw new AxisFault("Service '" + serviceName + "' not found in SOAPBC context");
        }
        return axisService;
    }

    public void init(AbstractComponent component, DeliveryChannel channel, AbstractServiceUnitManager bindingSUM, PetalsReceiver petalsReceiver, Logger log) {
        this.bindingSUM = bindingSUM;
        this.component = component;
        this.log = log;
        this.channel = channel;
        this.jbiService = new AxisService();
        this.petalsReceiver = petalsReceiver;
        this.jbiOperation = new InOutAxisOperation(PetalsAxisService.GENERIC_OPERATION_NAME);
        this.jbiOperation.setMessageReceiver((MessageReceiver)this.petalsReceiver);
        this.jbiService.addOperation(this.jbiOperation);
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    protected String extractWebServiceName(String serviceName) {
        int indexOfOperation = serviceName.indexOf(63);
        indexOfOperation = indexOfOperation > 0 ? indexOfOperation : serviceName.length();
        String servicesMapping = this.component.getComponentExtensions().get((Object)"http-services-mapping");
        int indexOfService = serviceName.lastIndexOf(servicesMapping + '/');
        indexOfService = indexOfService > 0 ? indexOfService + servicesMapping.length() + 1 : 0;
        return serviceName.substring(indexOfService, indexOfOperation);
    }
}

