/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.ow2.petals.binding.soap.listener.incoming.PetalsAxisService;
import org.ow2.petals.binding.soap.listener.incoming.RESTProcessor;
import org.ow2.petals.binding.soap.listener.incoming.RequestProcessor;
import org.ow2.petals.binding.soap.listener.incoming.SOAPProcessor;
import org.ow2.petals.component.framework.AbstractComponent;

public class PetalsReceiver
extends AbstractMessageReceiver {
    protected Map<String, RequestProcessor> requestProcessors;
    protected AbstractComponent component;
    protected DeliveryChannel channel;
    protected Logger logger;

    public PetalsReceiver(AbstractComponent component, DeliveryChannel channel, Logger logger) {
        this.logger = logger;
        this.component = component;
        this.channel = channel;
        this.requestProcessors = new HashMap<String, RequestProcessor>();
        this.initRequestProcessors();
    }

    protected void initRequestProcessors() {
        this.addProcessor(new RESTProcessor(this.component, this.channel, this.logger));
        this.addProcessor(new SOAPProcessor(this.component, this.channel, this.logger));
    }

    protected void addProcessor(RequestProcessor processor) {
        this.requestProcessors.put(processor.getProcessorName(), processor);
    }

    public final void invokeBusinessLogic(MessageContext msgContext) throws AxisFault {
        this.logger.log(Level.FINE, "Receiving a message from Axis2 engine");
        Parameter param = new Parameter("sendStacktraceDetailsWithFaults", (Object)Boolean.TRUE);
        if (msgContext.getAxisOperation() != null) {
            msgContext.getAxisOperation().addParameter(param);
        } else if (msgContext.getAxisService() != null) {
            msgContext.getAxisService().addParameter(param);
        } else if (msgContext.getAxisServiceGroup() != null) {
            msgContext.getAxisServiceGroup().addParameter(param);
        }
        MessageContext outMsgContext = null;
        try {
            outMsgContext = this.process(msgContext);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (outMsgContext != null) {
            this.sendBackResponse(outMsgContext);
        }
    }

    protected void sendBackResponse(MessageContext outMsgContext) throws AxisFault {
        AxisEngine.send((MessageContext)outMsgContext);
    }

    protected MessageContext process(MessageContext inContext) throws AxisFault, UnsupportedEncodingException {
        if (!(inContext.getAxisService() instanceof PetalsAxisService)) {
            throw new AxisFault("Can not retrieve a valid PEtALS Axis service from context", "Client");
        }
        RequestProcessor processor = this.getProcessor(inContext);
        if (processor == null) {
            throw new AxisFault("Can not process the incoming request, message processor has not been found for this type of request");
        }
        return processor.process(inContext, this.getSOAPFactory(inContext));
    }

    protected RequestProcessor getProcessor(MessageContext context) {
        RequestProcessor result = null;
        result = context.isDoingREST() ? this.getRESTProcessor() : this.getSOAPProcessor();
        return result;
    }

    protected RequestProcessor getRESTProcessor() {
        return this.requestProcessors.get("REST");
    }

    protected RequestProcessor getSOAPProcessor() {
        return this.requestProcessors.get("SOAP");
    }
}

