/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.Utils;
import org.ow2.petals.binding.soap.listener.incoming.PetalsAxisService;
import org.ow2.petals.binding.soap.listener.incoming.RequestProcessor;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;

public class RESTProcessor
extends RequestProcessor {
    public RESTProcessor(AbstractComponent component, DeliveryChannel channel, Logger log) {
        super(component, channel, log);
    }

    protected SOAPEnvelope createEnvelopeFromGet(MessageContext inContext, QName operation, String nsUri, String nsPrefix, SOAPFactory factory) {
        OMNamespace namespace = null;
        SOAPEnvelope env = factory.createSOAPEnvelope();
        if (nsUri != null) {
            namespace = factory.createOMNamespace(nsUri, nsPrefix);
            env.declareNamespace(namespace);
        }
        SOAPBody body = factory.createSOAPBody(env);
        OMElement root = factory.createOMElement(operation, (OMContainer)body);
        root.setNamespace(namespace);
        EndpointReference toEPR = inContext.getTo();
        String filePart = toEPR.getAddress();
        Map<String, String> params = this.getURLParameters(filePart, inContext.getConfigurationContext().getServiceContextPath());
        List<String> keys = this.getOrderedURLKeys(filePart, inContext.getConfigurationContext().getServiceContextPath());
        for (String key : keys) {
            String value = params.get(key);
            OMElement element = factory.createOMElement(key, namespace, (OMContainer)root);
            element.setText(value);
            root.addChild((OMNode)element);
        }
        return env;
    }

    protected SOAPEnvelope createEnvelopeFromPost(MessageContext inContext, String nsUri, String nsPrefix, SOAPFactory factory) {
        SOAPEnvelope envelope = inContext.getEnvelope();
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().log(Level.FINE, "POST envelope before : " + envelope);
        }
        OMNamespace namespace = null;
        if (nsUri != null) {
            namespace = factory.createOMNamespace(nsUri, nsPrefix);
        }
        if (namespace != null) {
            envelope.declareNamespace(namespace);
            SOAPBody body = envelope.getBody();
            body.declareNamespace(namespace);
            OMElement rootElement = body.getFirstElement();
            this.fixNameSpace(rootElement, namespace);
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().log(Level.FINE, "POST envelope after : " + envelope);
        }
        return envelope;
    }

    private void fixNameSpace(OMElement element, OMNamespace namespace) {
        if (element.getNamespace() == null) {
            element.setNamespace(namespace);
        }
        Iterator iter = element.getChildElements();
        while (iter.hasNext()) {
            OMElement childElement = (OMElement)iter.next();
            this.fixNameSpace(childElement, namespace);
        }
    }

    protected QName getJBIOperationFromURL(MessageContext inContext) {
        QName operation = null;
        EndpointReference toEPR = inContext.getTo();
        String filePart = toEPR.getAddress();
        String[] values = Utils.parseRequestURLForServiceAndOperation((String)filePart, (String)inContext.getConfigurationContext().getServiceContextPath());
        this.getLogger().log(Level.FINE, "Values : " + values[0] + ", " + values[1]);
        if (values[1] != null && values[1].length() != 0) {
            operation = new QName(values[1]);
        }
        return operation;
    }

    private List<String> getOrderedURLKeys(String path, String servicePath) {
        LinkedList<String> result = new LinkedList<String>();
        int index = path.lastIndexOf(servicePath);
        if (-1 != index) {
            int serviceStart = index + servicePath.length();
            if (path.length() > serviceStart + 1) {
                String afterService = path.substring(serviceStart + 1);
                int queryIndex = afterService.indexOf(63);
                String query = "";
                if (queryIndex > 0) {
                    query = afterService.substring(queryIndex + 1, afterService.length());
                }
                if (query.length() > 0) {
                    StringTokenizer tokenizer = new StringTokenizer(query, "&");
                    while (tokenizer.hasMoreElements()) {
                        String token = (String)tokenizer.nextElement();
                        if (!token.contains("=")) continue;
                        result.add(token.substring(0, token.indexOf("=")));
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected String getProcessorName() {
        return "REST";
    }

    private Map<String, String> getURLParameters(String path, String servicePath) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int index = path.lastIndexOf(servicePath);
        if (-1 != index) {
            int serviceStart = index + servicePath.length();
            if (path.length() > serviceStart + 1) {
                String afterService = path.substring(serviceStart + 1);
                int queryIndex = afterService.indexOf(63);
                String query = "";
                if (queryIndex > 0) {
                    query = afterService.substring(queryIndex + 1, afterService.length());
                }
                if (query.length() > 0) {
                    StringTokenizer tokenizer = new StringTokenizer(query, "&");
                    while (tokenizer.hasMoreElements()) {
                        String token = (String)tokenizer.nextElement();
                        if (!token.contains("=")) continue;
                        parameters.put(token.substring(0, token.indexOf("=")), token.substring(token.indexOf("=") + 1, token.length()));
                    }
                }
            }
        }
        return parameters;
    }

    @Override
    protected MessageContext process(MessageContext inContext, SOAPFactory factory) throws AxisFault, UnsupportedEncodingException {
        this.getLogger().log(Level.FINE, "Processing the incoming REST message");
        PetalsAxisService axisService = (PetalsAxisService)inContext.getAxisService();
        ConfigurationExtensions extensions = axisService.getConsumesCDKExtensions();
        QName jbiOperation = null;
        String method = (String)inContext.getProperty("HTTP_METHOD_OBJECT");
        SOAPEnvelope env = inContext.getEnvelope();
        String uri = SUPropertiesHelper.retrieveRESTAddNSURIOnRequest(extensions);
        String prefix = SUPropertiesHelper.retrieveRESTAddNSPrefixOnRequest(extensions);
        if ("GET".equals(method)) {
            jbiOperation = this.getJBIOperationFromURL(inContext);
            if (jbiOperation == null) {
                throw new AxisFault("Operation not found in message context, check the request URL (http://HOST:PORT/petals/services/SERVICE/OPERATION?PARAM=VALUE)", "Client");
            }
            env = this.createEnvelopeFromGet(inContext, jbiOperation, uri, prefix, factory);
        } else if ("POST".equals(method) || "PUT".equals(method) || "DELETE".equals(method)) {
            jbiOperation = this.getJBIOperationFromURL(inContext);
            if (jbiOperation == null) {
                throw new AxisFault("Operation not found in message context, check the request URL (http://HOST:PORT/petals/services/SERVICE/OPERATION?PARAM=VALUE)", "Client");
            }
            env = this.createEnvelopeFromPost(inContext, uri, prefix, factory);
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().log(Level.FINE, "JBI OPERATION : " + jbiOperation);
            this.getLogger().log(Level.FINE, "HTTP METHOD : " + method);
            this.getLogger().log(Level.FINE, "SOAP ENVELOPE : " + env.toString());
        }
        inContext.setEnvelope(env);
        long timeout = SUPropertiesHelper.retrieveTimeout(extensions);
        MEPType mep = axisService.getConsumes().getMep();
        MessageExchange exchange = null;
        try {
            exchange = this.createMessageExchange(inContext, jbiOperation, mep, axisService);
        }
        catch (AxisFault e) {
            String errorMsg = "Error while transforming SOAP request to JBI MessageExchange";
            this.getLogger().log(Level.SEVERE, "Error while transforming SOAP request to JBI MessageExchange", e);
            throw new AxisFault("Error while transforming SOAP request to JBI MessageExchange", "Server", (Throwable)e);
        }
        catch (MessagingException e) {
            String errorMsg = "Error while transforming SOAP request to JBI MessageExchange";
            this.getLogger().log(Level.SEVERE, "Error while transforming SOAP request to JBI MessageExchange", e);
            throw new AxisFault("Error while transforming SOAP request to JBI MessageExchange", "Server", (Throwable)e);
        }
        boolean sent = false;
        try {
            sent = timeout == -1L ? this.getChannel().sendSync(exchange) : this.getChannel().sendSync(exchange, timeout);
        }
        catch (MessagingException e) {
            String errorMsg = "Error while sending message through JBI NMR.";
            this.getLogger().log(Level.SEVERE, "Error while sending message through JBI NMR.", e);
            throw new AxisFault("Error while sending message through JBI NMR.", "Server", (Throwable)e);
        }
        if (!sent) {
            throw new AxisFault("A timeout occurs calling the consumed service.", "Server");
        }
        return this.processJBIResponse(exchange, inContext, factory);
    }

    @Override
    protected MessageContext processJBIResponse(MessageExchange exchange, MessageContext inMessage, SOAPFactory factory) throws AxisFault, UnsupportedEncodingException {
        MessageContext outMessage = super.processJBIResponse(exchange, inMessage, factory);
        PetalsAxisService axisService = (PetalsAxisService)inMessage.getAxisService();
        ConfigurationExtensions extensions = axisService.getConsumesCDKExtensions();
        List<String> prefixes = SUPropertiesHelper.retrieveRESTRemovePrefixOnResponse(extensions);
        if (prefixes != null) {
            SOAPEnvelope envelope = outMessage.getEnvelope();
            this.removeNSPrefixes(envelope, prefixes);
            outMessage.setEnvelope(envelope);
        }
        return outMessage;
    }

    private void removeNSPrefixes(SOAPEnvelope envelope, List<String> prefixes) {
        OMElement element = envelope.getBody().getFirstElement();
        for (String prefix : prefixes) {
            this.removePrefix(element, prefix);
        }
    }

    private void removePrefix(OMElement element, String prefixName) {
        OMNamespace omns = element.getNamespace();
        boolean same = false;
        if (omns != null) {
            same = prefixName.equals(element.getNamespace().getPrefix());
        }
        if (prefixName == null || same || "*".equals(prefixName)) {
            element.setNamespace(null);
        }
        Iterator attributes = element.getAllAttributes();
        while (attributes.hasNext()) {
            OMAttribute attribute = (OMAttribute)attributes.next();
            if (attribute.getNamespace() == null || !"xmlns".equals(attribute.getNamespace().getPrefix())) continue;
            element.removeAttribute(attribute);
        }
        Iterator iter = element.getChildElements();
        while (iter.hasNext()) {
            OMElement element2 = (OMElement)iter.next();
            this.removePrefix(element2, prefixName);
        }
    }
}

