/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.handler.WSHandlerResult;
import org.ow2.petals.binding.soap.listener.incoming.PetalsAxisService;
import org.ow2.petals.binding.soap.util.Marshaller;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.message.ExchangeImpl;

public abstract class RequestProcessor {
    private Logger logger = null;
    private DeliveryChannel channel = null;
    private AbstractComponent component = null;
    private MessageExchangeFactory exchangeFactory = null;

    public RequestProcessor(AbstractComponent component, DeliveryChannel channel, Logger log) {
        this.component = component;
        this.channel = channel;
        this.logger = log;
        this.exchangeFactory = channel.createExchangeFactory();
    }

    protected final void closeMessageExchange(MessageExchange exchange) throws AxisFault {
        try {
            exchange.setStatus(ExchangeStatus.DONE);
            this.getChannel().send(exchange);
        }
        catch (MessagingException e) {
            String errorMsg = "Error while closing JBI MessageExchange.";
            this.getLogger().log(Level.WARNING, "Error while closing JBI MessageExchange.", e);
            throw new AxisFault("Error while closing JBI MessageExchange.", "Server", (Throwable)e);
        }
    }

    protected final MessageExchange createMessageExchange(MEPType mep) throws MessagingException {
        InOptionalOut exchange = null;
        if (mep != null) {
            if (MEPType.IN_ONLY.equals((Object)mep)) {
                exchange = this.exchangeFactory.createInOnlyExchange();
            } else if (MEPType.ROBUST_IN_ONLY.equals((Object)mep)) {
                exchange = this.exchangeFactory.createRobustInOnlyExchange();
            } else if (MEPType.IN_OUT.equals((Object)mep)) {
                exchange = this.exchangeFactory.createInOutExchange();
            } else if (MEPType.IN_OPTIONAL_OUT.equals((Object)mep)) {
                exchange = this.exchangeFactory.createInOptionalOutExchange();
            }
        } else {
            exchange = this.exchangeFactory.createInOptionalOutExchange();
        }
        return exchange;
    }

    protected final MessageExchange createMessageExchange(MessageContext inContext, QName operation, MEPType mep, PetalsAxisService axisService) throws AxisFault, MessagingException {
        ExchangeImpl exchangeWrapper = null;
        Source source = null;
        ServiceEndpoint endpoint = null;
        try {
            Subject subject;
            MessageExchange exchange = this.createMessageExchange(mep);
            ConfigurationExtensions extension = axisService.getConsumesCDKExtensions();
            boolean axis1Compatibility = SUPropertiesHelper.isAxis1CompatibilityEnabled(extension);
            source = inContext.getAttachmentMap() == null || inContext.getAttachmentMap().getContentIDSet() != null && inContext.getAttachmentMap().getContentIDSet().size() <= 0 ? Marshaller.createSourceContent(inContext.getEnvelope(), axis1Compatibility) : Marshaller.createSourceContentAndAttachment(inContext);
            exchangeWrapper = new ExchangeImpl(exchange);
            exchangeWrapper.setOperation(operation);
            exchangeWrapper.setInterfaceName(axisService.getConsumes().getInterfaceName());
            if (axisService.getConsumes().getServiceName() != null) {
                exchangeWrapper.setService(axisService.getConsumes().getServiceName());
                if (axisService.getConsumes().getEndpointName() != null && (endpoint = this.component.getContext().getEndpoint(axisService.getConsumes().getServiceName(), axisService.getConsumes().getEndpointName())) == null) {
                    throw new AxisFault("No endpoint satisfying service-name and endpoint name is found: " + axisService.getConsumes().getServiceName().toString() + ", " + axisService.getConsumes().getEndpointName());
                }
                exchangeWrapper.setEndpoint(endpoint);
            }
            exchangeWrapper.setInMessageContent(source);
            Marshaller.setAttachments(inContext.getAttachmentMap(), exchangeWrapper.getInMessage());
            if (this.isSecuredService(axisService) && (subject = this.createSecuritySubject(inContext)) != null) {
                exchangeWrapper.getInMessage().setSecuritySubject(subject);
            }
            Marshaller.setProperties(inContext, exchangeWrapper.getInMessage());
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        return exchangeWrapper.getMessageExchange();
    }

    protected final Subject createSecuritySubject(MessageContext messageContext) {
        this.getLogger().fine("Trying to create JAAS Security Subject");
        Subject subject = null;
        Vector wssec = (Vector)messageContext.getProperty("RECV_RESULTS");
        if (wssec != null) {
            for (WSHandlerResult wshandler : wssec) {
                Vector wsSecEngineResults = wshandler.getResults();
                for (Object object : wsSecEngineResults) {
                    WSSecurityEngineResult wsresult = (WSSecurityEngineResult)object;
                    Principal principal = (Principal)wsresult.get((Object)"principal");
                    if (principal == null) continue;
                    if (subject == null) {
                        subject = new Subject();
                    }
                    this.getLogger().fine("Got a principal from input message context : " + principal.getName());
                    subject.getPrincipals().add(principal);
                }
            }
        }
        return subject;
    }

    public final DeliveryChannel getChannel() {
        return this.channel;
    }

    public final Logger getLogger() {
        return this.logger;
    }

    protected abstract String getProcessorName();

    protected final void handleFault(MessageExchange exchange, MessageContext outMessage, SOAPFactory factory) throws AxisFault {
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("We found a fault into the JBI exchange.");
        }
        try {
            SOAPEnvelope envelope = Marshaller.createSOAPEnvelope(factory, (NormalizedMessage)exchange.getFault(), true);
            outMessage.setEnvelope(envelope);
        }
        catch (AxisFault e) {
            String errorMsg = "Error while creating SOAP Fault response.";
            this.getLogger().log(Level.WARNING, "Error while creating SOAP Fault response.", e);
            throw new AxisFault("Error while creating SOAP Fault response.", "Server", (Throwable)e);
        }
    }

    protected final void handleResponseAttachments(SOAPFactory soapFactory, NormalizedMessage nm, MessageContext outMessage) throws UnsupportedEncodingException {
        Marshaller.fillSOAPBodyWithAttachments(nm, soapFactory, outMessage);
        SOAPEnvelope env = outMessage.getEnvelope();
        if (env != null && this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "SOAPENVELOPE AFTER Attachment handling");
            this.logger.log(Level.FINE, outMessage.getEnvelope().toString());
        }
    }

    protected final boolean isSecuredService(PetalsAxisService service) {
        ConfigurationExtensions extensions = service.getConsumesCDKExtensions();
        String modules = extensions.get((Object)"modules");
        return modules != null && modules.indexOf("rampart") >= 0;
    }

    protected abstract MessageContext process(MessageContext var1, SOAPFactory var2) throws AxisFault, UnsupportedEncodingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageContext processJBIResponse(MessageExchange exchange, MessageContext inMessage, SOAPFactory factory) throws AxisFault, UnsupportedEncodingException {
        if (exchange.getStatus().equals(ExchangeStatus.DONE)) {
            this.getLogger().fine("Receive a Done status message");
            return null;
        }
        if (exchange.getStatus().equals(ExchangeStatus.ERROR)) {
            this.getLogger().fine("Receive an Error status message");
            throw new AxisFault("Server", (Throwable)exchange.getError());
        }
        if (exchange.getStatus().equals(ExchangeStatus.ACTIVE)) {
            MessageContext outMessage;
            block11: {
                this.getLogger().fine("Receive an Active status message");
                outMessage = MessageContextBuilder.createOutMessageContext((MessageContext)inMessage);
                outMessage.getOperationContext().addMessageContext(outMessage);
                try {
                    if (exchange.getFault() != null) {
                        this.handleFault(exchange, outMessage, factory);
                        break block11;
                    }
                    try {
                        NormalizedMessage nm = null;
                        if (exchange instanceof InOptionalOut || exchange instanceof InOut) {
                            nm = exchange.getMessage("out");
                        }
                        if (nm == null) {
                            String errorMsg = "The MEP '" + exchange.getPattern() + "' does not accept a null response";
                            this.getLogger().log(Level.WARNING, errorMsg);
                            throw new AxisFault(errorMsg, "Server");
                        }
                        exchange.getInterfaceName();
                        SOAPEnvelope envelope = Marshaller.createSOAPEnvelope(factory, nm, false);
                        outMessage.setEnvelope(envelope);
                        this.handleResponseAttachments(factory, nm, outMessage);
                    }
                    catch (AxisFault e) {
                        String errorMsg = "Error while creating SOAP response";
                        this.getLogger().log(Level.WARNING, "Error while creating SOAP response", e);
                        throw new AxisFault("Error while creating SOAP response", "Server", (Throwable)e);
                    }
                }
                finally {
                    this.closeMessageExchange(exchange);
                }
            }
            return outMessage;
        }
        throw new AxisFault("JBI message has wrong status " + exchange.getStatus().toString());
    }

    protected final QName retrieveOperationFromSOAPBody(MessageContext message) {
        QName result = null;
        SOAPEnvelope env = message.getEnvelope();
        SOAPBody body = env.getBody();
        OMElement operation = body.getFirstElement();
        if (operation != null) {
            result = operation.getQName();
        }
        return result;
    }
}

