/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.XMLUtils;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.binding.BindingProtocol;
import org.ow2.petals.binding.soap.listener.incoming.PetalsAxisService;
import org.ow2.petals.binding.soap.listener.incoming.RequestProcessor;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.binding.soap.util.WsdlHelper;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.util.StringHelper;
import org.w3c.dom.Element;

public class SOAPProcessor
extends RequestProcessor {
    public SOAPProcessor(AbstractComponent component, DeliveryChannel channel, Logger log) {
        super(component, channel, log);
    }

    @Override
    protected String getProcessorName() {
        return "SOAP";
    }

    @Override
    protected MessageContext process(MessageContext inContext, SOAPFactory factory) throws AxisFault, UnsupportedEncodingException {
        this.getLogger().log(Level.FINE, "Processing the incoming SOAP message");
        PetalsAxisService axisService = (PetalsAxisService)inContext.getAxisService();
        String soapAction = inContext.getWSAAction();
        this.getLogger().log(Level.FINEST, "soapAction found in the incoming message : " + soapAction);
        QName jbiOperation = null;
        MEPType mep = null;
        String transportInName = inContext.getTransportIn().getName();
        BindingOperation bindingOperation = this.retrieveSOAPBindingOperation(inContext, soapAction, axisService, transportInName);
        if (bindingOperation != null) {
            BindingProtocol.SOAPMEPConstants mepFromBindingOperation;
            jbiOperation = ((Operation)bindingOperation.getOperation()).getQName();
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().log(Level.FINEST, "jbiOperation retrieved : {" + jbiOperation.getNamespaceURI() + "}" + jbiOperation.getLocalPart());
            }
            if ((mepFromBindingOperation = bindingOperation.getMEP()) == BindingProtocol.SOAPMEPConstants.ONE_WAY) {
                mep = MEPType.IN_ONLY;
            } else if (mepFromBindingOperation == BindingProtocol.SOAPMEPConstants.REQUEST_RESPONSE) {
                mep = MEPType.IN_OUT;
            }
        } else {
            jbiOperation = this.retrieveJBIOperationUsingOldMechanism(inContext, soapAction);
        }
        if (jbiOperation == null) {
            throw new AxisFault("Operation not found in message context", "Client");
        }
        if (mep == null) {
            mep = axisService.getConsumes().getMep();
        }
        MessageExchange exchange = null;
        try {
            exchange = this.createMessageExchange(inContext, jbiOperation, mep, axisService);
        }
        catch (AxisFault e) {
            String errorMsg = "Error while transforming SOAP request to JBI MessageExchange";
            this.getLogger().log(Level.SEVERE, "Error while transforming SOAP request to JBI MessageExchange", e);
            throw new AxisFault("Error while transforming SOAP request to JBI MessageExchange", "Server", (Throwable)e);
        }
        catch (MessagingException e) {
            String errorMsg = "Error while transforming SOAP request to JBI MessageExchange";
            this.getLogger().log(Level.SEVERE, "Error while transforming SOAP request to JBI MessageExchange", e);
            throw new AxisFault("Error while transforming SOAP request to JBI MessageExchange", "Server", (Throwable)e);
        }
        exchange.setProperty("soap-action", (Object)soapAction);
        long timeout = SUPropertiesHelper.retrieveTimeout(axisService.getConsumesCDKExtensions());
        boolean sent = false;
        try {
            sent = timeout == -1L ? this.getChannel().sendSync(exchange) : this.getChannel().sendSync(exchange, timeout);
        }
        catch (MessagingException e) {
            String errorMsg = "Error while sending JBI exchange with id '" + exchange.getExchangeId() + "'";
            this.getLogger().log(Level.WARNING, errorMsg, e);
            throw new AxisFault(errorMsg, "Server", (Throwable)e);
        }
        if (!sent) {
            String errorMsg = "A timeout occurs on JBI exchange with id '" + exchange.getExchangeId() + "'";
            this.getLogger().log(Level.WARNING, errorMsg);
            throw new AxisFault(errorMsg, "Server");
        }
        return this.processJBIResponse(exchange, inContext, factory);
    }

    private BindingOperation retrieveSOAPBindingOperation(MessageContext inContext, String soapAction, PetalsAxisService axisService, String transport) throws AxisFault {
        Description desc = axisService.getDescription(transport);
        BindingOperation bindingOperation = null;
        if (desc != null) {
            if (soapAction != null) {
                bindingOperation = WsdlHelper.findOperationUsingSoapAction(soapAction, desc);
            }
            if (bindingOperation == null) {
                try {
                    Element firstElement = XMLUtils.toDOM((OMElement)inContext.getEnvelope().getBody().getFirstElement());
                    String endpointName = axisService.getConsumes().getEndpointName();
                    QName serviceName = axisService.getConsumes().getServiceName();
                    bindingOperation = WsdlHelper.findOperationUsingElement(firstElement, desc, endpointName, serviceName);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return bindingOperation;
    }

    private QName retrieveJBIOperationUsingOldMechanism(MessageContext inContext, String soapAction) {
        QName jbiOperation;
        if (!StringHelper.isNullOrEmpty(soapAction)) {
            QName operation;
            String namespace = soapAction.substring(0, inContext.getWSAAction().lastIndexOf(47) + 1);
            String opname = inContext.getWSAAction().substring(inContext.getWSAAction().lastIndexOf(47) + 1);
            jbiOperation = operation = new QName(namespace, opname);
        } else {
            jbiOperation = this.retrieveOperationFromSOAPBody(inContext);
        }
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().log(Level.FINEST, "jbiOperation retrieved using old mechanism : {" + jbiOperation.getNamespaceURI() + "}" + jbiOperation.getLocalPart());
        }
        return jbiOperation;
    }
}

