/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.messaging.DeliveryChannel;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.binding.soap.listener.incoming.PetalsDispatcher;
import org.ow2.petals.binding.soap.listener.incoming.PetalsReceiver;
import org.ow2.petals.binding.soap.listener.incoming.SoapServerConfig;
import org.ow2.petals.binding.soap.listener.incoming.jetty.SoapServer;
import org.ow2.petals.binding.soap.util.ComponentPropertiesHelper;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;

public class SoapExternalListenerManager {
    protected Logger logger;
    protected Set<String> addresses;
    protected DeliveryChannel channel;
    protected AbstractComponent component;
    protected AbstractServiceUnitManager bindingSUM;
    protected SoapServer httpServer;
    protected SoapServerConfig serverConfig;
    protected SoapComponentContext soapContext;
    protected PetalsReceiver petalsReceiver;

    public SoapExternalListenerManager(AbstractComponent component, DeliveryChannel dchannel, AbstractServiceUnitManager bindingSUM, SoapComponentContext soapContext, PetalsReceiver petalsReceiver, Logger logger) throws JBIException {
        this.logger = logger;
        this.addresses = new HashSet<String>();
        this.bindingSUM = bindingSUM;
        this.channel = dchannel;
        this.component = component;
        this.soapContext = soapContext;
        this.serverConfig = SoapExternalListenerManager.createServerConfig(logger, component.getComponentExtensions());
        this.petalsReceiver = petalsReceiver;
    }

    private static final SoapServerConfig createServerConfig(Logger logger, ConfigurationExtensions extensions) throws JBIException {
        SoapServerConfig soapConfig = new SoapServerConfig();
        String host = ComponentPropertiesHelper.getHttpHostName(extensions);
        soapConfig.setHost(logger, host);
        soapConfig.setHttpPort(ComponentPropertiesHelper.getHttpPort(logger, extensions));
        soapConfig.setProvidesList(ComponentPropertiesHelper.isProvidingServicesList(extensions));
        soapConfig.setServicesContext(ComponentPropertiesHelper.getServicesContext(extensions));
        soapConfig.setServicesMapping(ComponentPropertiesHelper.getServicesMapping(extensions));
        soapConfig.setJettyThreadMaxPoolSize(ComponentPropertiesHelper.getHttpThreadMaxPoolSize(logger, extensions));
        soapConfig.setJettyThreadMinPoolSize(ComponentPropertiesHelper.getHttpThreadMinPoolSize(logger, extensions));
        soapConfig.setJettyAcceptors(ComponentPropertiesHelper.getHttpAcceptors(logger, extensions));
        SoapExternalListenerManager.setHttpsServerConfig(logger, extensions, soapConfig);
        return soapConfig;
    }

    private static void setHttpsServerConfig(Logger logger, ConfigurationExtensions extensions, SoapServerConfig soapConfig) {
        boolean isHttpsEnabled = ComponentPropertiesHelper.isHttpsEnabled(extensions);
        if (isHttpsEnabled) {
            soapConfig.setHttpsPort(ComponentPropertiesHelper.getHttpsPort(logger, extensions));
            String httpsKeystoreFile = ComponentPropertiesHelper.getHttpsKeystoreFile(extensions);
            if (httpsKeystoreFile != null && !httpsKeystoreFile.trim().equals("")) {
                File httpsKeystore = new File(httpsKeystoreFile);
                if (httpsKeystore.exists()) {
                    soapConfig.setHttpsKeytoreFile(httpsKeystoreFile);
                    soapConfig.setHttpsKeytoreType(ComponentPropertiesHelper.getHttpsKeystoreType(extensions));
                    soapConfig.setHttpsKeytorePassword(ComponentPropertiesHelper.getHttpsKeystorePassword(extensions));
                    soapConfig.setHttpsKeyPassword(ComponentPropertiesHelper.getHttpsKeyPassword(extensions));
                    String httpsTrustoreFile = ComponentPropertiesHelper.getHttpsTruststoreFile(extensions);
                    if (httpsTrustoreFile != null && !httpsTrustoreFile.trim().equals("")) {
                        File httpsTruststore = new File(httpsTrustoreFile);
                        if (httpsTruststore.exists()) {
                            soapConfig.setHttpsTruststoreFile(httpsTrustoreFile);
                            soapConfig.setHttpsTruststoreType(ComponentPropertiesHelper.getHttpsTruststoreType(extensions));
                            soapConfig.setHttpsTruststorePassword(ComponentPropertiesHelper.getHttpsTruststorePassword(extensions));
                        } else if (logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, "HTTPS Client authentication in the consumer role is disabled because the trustore file does not exist.");
                        }
                    }
                } else {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "HTTPS is disabled because the keystore file does not exist.");
                    }
                    isHttpsEnabled = false;
                }
            } else {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "HTTPS is disabled because the keystore file is not correctly set.");
                }
                isHttpsEnabled = false;
            }
        }
        soapConfig.setHttpsEnabled(isHttpsEnabled);
        soapConfig.setHttpsClientAuthEnabled(ComponentPropertiesHelper.isHttpsClientAuthEnabled(extensions));
    }

    public Set<String> getAddresses() {
        return this.addresses;
    }

    public SoapServerConfig getSoapServerConfig() {
        return this.serverConfig;
    }

    private static final PetalsDispatcher retrievePetalsDispatcherFromAxisConfiguration(AxisConfiguration axisConfiguration) throws AxisFault {
        PetalsDispatcher petalsDispatcher = null;
        List axisPhases = axisConfiguration.getInFlowPhases();
        Iterator iter = axisPhases.iterator();
        while (iter.hasNext() && petalsDispatcher == null) {
            Phase phase = (Phase)iter.next();
            if (!phase.getPhaseName().equalsIgnoreCase("Dispatch")) continue;
            Iterator iterator = phase.getHandlers().iterator();
            while (iterator.hasNext() && petalsDispatcher == null) {
                Handler handler = (Handler)iterator.next();
                if (!handler.getName().equalsIgnoreCase("PetalsDispatcher")) continue;
                petalsDispatcher = (PetalsDispatcher)handler;
            }
        }
        if (petalsDispatcher == null) {
            throw new AxisFault("The PetalsDispatcher object can not be retrieved from the AxisConfiguration.");
        }
        return petalsDispatcher;
    }

    public void start(AxisConfiguration axisConfiguration) throws AxisFault, MissingResourceException, JBIException {
        Logger jettyLogger = this.component.getContext().getLogger("jetty", null);
        this.httpServer = new SoapServer(this.serverConfig, this.soapContext, jettyLogger);
        if (this.serverConfig.isValidHostName()) {
            this.httpServer.start();
        } else if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, "Specified host name in the SU is not valid consequently the HTTP server is not started");
        }
        PetalsDispatcher petalsDispatcher = SoapExternalListenerManager.retrievePetalsDispatcherFromAxisConfiguration(axisConfiguration);
        petalsDispatcher.init(this.component, this.channel, this.bindingSUM, this.petalsReceiver, this.logger);
        if (this.serverConfig.isValidHostName() && this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Component Information is available at " + this.serverConfig.getBaseURL());
        }
    }

    public void stop() throws AxisFault {
        this.httpServer.stop();
    }

    public void shutdown() throws AxisFault {
        this.httpServer.shutdown();
    }

    public SoapServer getHttpServer() {
        return this.httpServer;
    }
}

