/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming.servlet;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.transport.http.AxisServlet;
import org.ow2.petals.binding.soap.listener.incoming.PetalsAxisService;
import org.ow2.petals.binding.soap.listener.incoming.jetty.ServerStats;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SoapServlet
extends AxisServlet {
    protected transient ConfigurationContext copyOfconfigContext;
    private final transient ServerStats stats;
    private static final long serialVersionUID = -8035921158344750120L;

    public SoapServlet(ConfigurationContext configContext, ServerStats stats) {
        this.copyOfconfigContext = configContext;
        this.stats = stats;
    }

    private String createServiceName(HttpServletRequest request) {
        String remove = request.getContextPath() + request.getServletPath() + "/";
        String res = request.getRequestURI().replace(remove, "");
        return res;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryString = request.getQueryString();
        if (this.isImportWSDLRequest(queryString)) {
            this.printImportedDocuments(request, response);
        } else {
            this.stats.newGetRequest();
            response.addHeader("Connection", "Close");
            super.doGet(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.stats.newPostRequest();
        new HttpServletRequestWrapper(request);
        response.addHeader("Connection", "Close");
        super.doPost(request, response);
    }

    protected ConfigurationContext initConfigContext(ServletConfig config) throws ServletException {
        this.copyOfconfigContext.setProperty("ContainerManaged", (Object)"true");
        return this.copyOfconfigContext;
    }

    private boolean isImportWSDLRequest(String queryString) {
        return queryString != null && queryString.toLowerCase().startsWith("wsdl");
    }

    private void printImportedDocuments(HttpServletRequest request, HttpServletResponse response) throws AxisFault, IOException, ServletException {
        List exposedTransports;
        AxisService axisService = this.axisConfiguration.getService(this.createServiceName(request));
        if (axisService != null && (exposedTransports = axisService.getExposedTransports()).contains(request.getScheme()) && axisService instanceof PetalsAxisService) {
            String queryString = request.getQueryString();
            String requestURI = ((PetalsAxisService)axisService).getServiceURL(request.getScheme());
            String importsRootURI = requestURI.concat("?wsdl=");
            if ("wsdl".equals(queryString)) {
                try {
                    ServletOutputStream out = response.getOutputStream();
                    axisService.printWSDL((OutputStream)out, importsRootURI);
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    throw new ServletException("Error during streaming serialization", (Throwable)e);
                }
            } else {
                Map<URI, Document> importedDocsMap = null;
                importedDocsMap = ((PetalsAxisService)axisService).getImportedDocuments(importsRootURI);
                boolean find = false;
                for (Map.Entry<URI, Document> entry : importedDocsMap.entrySet()) {
                    if (!entry.getKey().toString().contains(queryString)) continue;
                    find = true;
                    Document importedDoc = entry.getValue();
                    ServletOutputStream out = response.getOutputStream();
                    try {
                        XMLPrettyPrinter.prettify((Node)importedDoc, (OutputStream)out, (String)XMLPrettyPrinter.getEncoding((Document)importedDoc));
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        throw new ServletException("Error on " + queryString + " streaming serialization", (Throwable)e);
                    }
                }
                if (!find) {
                    throw new ServletException("Error: Document unknown: " + queryString + ". Available documents are " + importedDocsMap.keySet().toString());
                }
            }
        }
    }
}

