/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.http.CommonsHTTPTransportSender;

public class Axis1SOAPFaultHTTPTransportSender
extends CommonsHTTPTransportSender {
    private static final String SOAP_RESPONSE_FAULT_LOCAL_NAME = "Fault";
    private static final String SOAP_RESPONSE_ENVELOPE_LOCAL_NAME = "Envelope";
    private static final String SOAP_ENVELOPE_NAMESPACE_URI = "http://schemas.xmlsoap.org/soap/envelope/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        InputStream inStream;
        Handler.InvocationResponse ir = super.invoke(msgContext);
        if (!msgContext.isServerSide() && (inStream = (InputStream)msgContext.getProperty("TRANSPORT_IN")) != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    Axis1SOAPFaultHTTPTransportSender.correctSOAPFault(inStream, baos);
                    ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
                    msgContext.setProperty("TRANSPORT_IN", (Object)is);
                }
                finally {
                    baos.close();
                }
            }
            catch (Exception e) {
                throw new AxisFault("Can not correct the incoming response", (Throwable)e);
            }
        }
        return ir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void correctSOAPFault(InputStream inStream, ByteArrayOutputStream baos) throws FactoryConfigurationError, XMLStreamException {
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        XMLStreamReader reader = inFactory.createXMLStreamReader(inStream);
        try {
            XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = outFactory.createXMLStreamWriter(baos);
            try {
                boolean done = false;
                while (!done) {
                    int event = reader.next();
                    if (event == 1) {
                        String prefix = reader.getPrefix();
                        String localName = reader.getLocalName();
                        String namespaceURI = reader.getNamespaceURI();
                        if (localName.equals(SOAP_RESPONSE_FAULT_LOCAL_NAME) && namespaceURI.equals(SOAP_ENVELOPE_NAMESPACE_URI)) {
                            writer.writeStartElement(prefix, localName, namespaceURI);
                            Axis1SOAPFaultHTTPTransportSender.writeNamespacesAndAttributes(reader, writer);
                            int levelFromFault = 1;
                            do {
                                if ((event = reader.next()) == 1) {
                                    prefix = reader.getPrefix();
                                    localName = reader.getLocalName();
                                    namespaceURI = reader.getNamespaceURI();
                                    if (levelFromFault == 1) {
                                        writer.writeStartElement(localName);
                                    } else {
                                        writer.writeStartElement(prefix, localName, namespaceURI);
                                    }
                                    Axis1SOAPFaultHTTPTransportSender.writeNamespacesAndAttributes(reader, writer);
                                    ++levelFromFault;
                                    continue;
                                }
                                if (event == 4) {
                                    String text = reader.getText();
                                    writer.writeCharacters(text);
                                    continue;
                                }
                                if (event != 2) continue;
                                --levelFromFault;
                                writer.writeEndElement();
                            } while (levelFromFault > 0);
                            continue;
                        }
                        writer.writeStartElement(prefix, localName, namespaceURI);
                        Axis1SOAPFaultHTTPTransportSender.writeNamespacesAndAttributes(reader, writer);
                        continue;
                    }
                    if (event == 4) {
                        String text = reader.getText();
                        writer.writeCharacters(text);
                        continue;
                    }
                    if (event != 2) continue;
                    writer.writeEndElement();
                    String localName = reader.getLocalName();
                    String namespaceURI = reader.getNamespaceURI();
                    if (!localName.equals(SOAP_RESPONSE_ENVELOPE_LOCAL_NAME) || !namespaceURI.equals(SOAP_ENVELOPE_NAMESPACE_URI)) continue;
                    done = true;
                }
            }
            finally {
                writer.close();
            }
        }
        finally {
            reader.close();
        }
    }

    private static final void writeNamespacesAndAttributes(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int namespaceCount = reader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String namespacePrefix = reader.getNamespacePrefix(i);
            String namespaceURI = reader.getNamespaceURI(i);
            writer.writeNamespace(namespacePrefix, namespaceURI);
        }
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributePrefix = reader.getAttributePrefix(i);
            String attributeNamespaceURI = reader.getAttributeNamespace(i);
            String attributeLocalName = reader.getAttributeLocalName(i);
            String attributeValue = reader.getAttributeValue(i);
            writer.writeAttribute(attributePrefix, attributeNamespaceURI, attributeLocalName, attributeValue);
        }
    }
}

