/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.RobustOutOnlyAxisOperation;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.ow2.petals.commons.util.IDGenerator;
import org.ow2.petals.component.framework.api.Message;

public class Axis2Utils {
    private static AtomicLong serviceCounter = new AtomicLong();
    private static ConfigurationContext axisCtx = null;
    private static AxisFault axisFault = null;

    public static ServiceClient createServiceClient(URI mep, QName operation) throws MessagingException {
        ServiceClient client = null;
        AxisService service = new AxisService("OutgoingWSClient" + IDGenerator.getInstance().getNewID() + serviceCounter.incrementAndGet());
        OutOnlyAxisOperation axisOperation = null;
        if (Message.MEPConstants.IN_ONLY_PATTERN.equals(mep)) {
            axisOperation = new OutOnlyAxisOperation(operation);
        } else if (Message.MEPConstants.ROBUST_IN_ONLY_PATTERN.equals(mep)) {
            axisOperation = new RobustOutOnlyAxisOperation(operation);
        } else if (Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN.equals(mep) || Message.MEPConstants.IN_OUT_PATTERN.equals(mep)) {
            axisOperation = new OutInAxisOperation(operation);
        }
        service.addOperation((AxisOperation)axisOperation);
        if (axisFault != null) {
            throw new MessagingException("Can't create the configuration", (Throwable)axisFault);
        }
        try {
            client = new ServiceClient(axisCtx, service);
        }
        catch (AxisFault e) {
            throw new MessagingException("Can't create ServiceClient", (Throwable)e);
        }
        return client;
    }

    public static Policy loadPolicy(File path, Logger logger) {
        Policy policy = null;
        if (path == null) {
            return null;
        }
        File policyFile = new File(path, "policy.xml");
        logger.info("Get the policy from " + policyFile.getAbsolutePath());
        if (policyFile.exists()) {
            try {
                StAXOMBuilder builder = new StAXOMBuilder((InputStream)new FileInputStream(policyFile));
                policy = PolicyEngine.getPolicy((OMElement)builder.getDocumentElement());
            }
            catch (FileNotFoundException e) {
                logger.warning(e.getMessage());
            }
            catch (XMLStreamException e) {
                logger.warning(e.getMessage());
            }
        }
        return policy;
    }

    private Axis2Utils() {
    }

    static {
        try {
            axisCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
        }
        catch (AxisFault ae) {
            axisFault = ae;
        }
    }
}

