/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import java.net.URL;
import java.util.Map;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.util.XMLUtils;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PetalsServiceClient
extends ServiceClient {
    public PetalsServiceClient(ConfigurationContext configContext, AxisService axisService) throws AxisFault {
        super(configContext, axisService);
    }

    public PetalsServiceClient(ConfigurationContext configContext, Definition wsdl4jDefinition, QName wsdlServiceName, String portName) throws AxisFault {
        super(configContext, wsdl4jDefinition, wsdlServiceName, portName);
    }

    public PetalsServiceClient(ConfigurationContext configContext, URL wsdlURL, QName wsdlServiceName, String portName) throws AxisFault {
        super(configContext, wsdlURL, wsdlServiceName, portName);
    }

    private void addAdditionalHeadersToEnvelope(SOAPEnvelope envelope, Map<String, DocumentFragment> headers) {
        SOAPHeader soapHeader = envelope.getHeader();
        for (DocumentFragment docfrag : headers.values()) {
            Node node = docfrag.getFirstChild();
            if (!(node instanceof Element)) continue;
            try {
                soapHeader.addChild((OMNode)XMLUtils.toOM((Element)((Element)node)));
            }
            catch (Throwable t) {}
        }
    }

    protected void fillSOAPEnvelope(MessageContext messageContext, OMElement xmlPayload) throws AxisFault {
        this.fillSOAPEnvelope(messageContext, xmlPayload, null);
    }

    protected void fillSOAPEnvelope(MessageContext messageContext, OMElement xmlPayload, Map<String, DocumentFragment> headers) throws AxisFault {
        messageContext.setServiceContext(this.getServiceContext());
        SOAPFactory soapFactory = this.getSOAPFactory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        if (xmlPayload != null) {
            envelope.getBody().addChild((OMNode)xmlPayload);
        }
        this.addHeadersToEnvelope(envelope);
        if (headers != null) {
            this.addAdditionalHeadersToEnvelope(envelope, headers);
        }
        messageContext.setEnvelope(envelope);
    }

    protected SOAPFactory getSOAPFactory() {
        String soapVersionURI = this.getOptions().getSoapVersionURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        return OMAbstractFactory.getSOAP11Factory();
    }

    public MessageContext sendReceiveBody(QName operationQName, OMElement xmlPayload, Map<String, DocumentFragment> headers) throws AxisFault {
        MessageContext messageContext = new MessageContext();
        this.fillSOAPEnvelope(messageContext, xmlPayload, headers);
        OperationClient operationClient = this.createClient(operationQName);
        operationClient.addMessageContext(messageContext);
        operationClient.execute(true);
        MessageContext response = operationClient.getMessageContext("In");
        return response;
    }
}

