/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.i18n.Messages;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AxiomUtils {
    private static final int DEFAULT_BYTE_ARRAY_SIZE = 8192;
    private static final QName REFID = QName.valueOf("id");
    private static final QName HREF = QName.valueOf("href");
    private static final String MULTIREF = "multiRef";

    private AxiomUtils() {
    }

    public static Source createSource(OMElement element) throws IOException, XMLStreamException {
        ByteArrayOutputStream osRequest = new ByteArrayOutputStream(8192);
        XMLStreamWriter xsw = StAXUtils.createXMLStreamWriter((OutputStream)osRequest);
        element.serializeAndConsume(xsw);
        xsw.close();
        osRequest.close();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DOMSource res = null;
        try {
            Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(osRequest.toByteArray()));
            res = new DOMSource(doc);
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLStreamException(e);
        }
        return res;
    }

    public static SOAPFactory getSOAPFactory(MessageContext msgContext) throws AxisFault {
        return AxiomUtils.getSOAPFactory(msgContext.getEnvelope());
    }

    public static SOAPFactory getSOAPFactory(SOAPEnvelope envelope) throws AxisFault {
        String nsURI = envelope.getNamespace().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage((String)"invalidSOAPversion"));
    }

    public static Map<String, OMElement> getHrefElements(OMElement element) {
        HashMap<String, OMElement> result = new HashMap<String, OMElement>();
        if (element.getQName().getLocalPart().equals(MULTIREF) && element.getAttribute(REFID) != null) {
            result.put(element.getAttributeValue(REFID), element);
        }
        Iterator iter = element.getChildElements();
        while (iter.hasNext()) {
            OMElement child = (OMElement)iter.next();
            Map<String, OMElement> tmp = AxiomUtils.getHrefElements(child);
            result.putAll(tmp);
        }
        return result;
    }

    public static String getHrefId(OMElement element) {
        return element != null && element.getAttribute(HREF) != null ? element.getAttributeValue(HREF).substring(1) : "";
    }

    public static boolean isMultirefElement(OMElement element) {
        return element != null && element.getLocalName().equals(MULTIREF);
    }

    public static boolean isHrefRedirect(OMElement element) {
        return element != null && element.getAttribute(HREF) != null;
    }

    public static void copy(SOAPFactory factory, OMContainer targetParent, OMNode sourceNode) {
        if (sourceNode instanceof SOAPHeaderBlock) {
            AxiomUtils.copySOAPHeaderBlock(factory, targetParent, (SOAPHeaderBlock)sourceNode);
        } else if (sourceNode instanceof SOAPFault) {
            AxiomUtils.copySOAPFault(factory, targetParent, (SOAPFault)sourceNode);
        } else if (sourceNode instanceof OMSourcedElement) {
            AxiomUtils.copyOMSourcedElement(factory, targetParent, (OMSourcedElement)sourceNode);
        } else if (sourceNode instanceof OMElement) {
            AxiomUtils.copyOMElement(factory, targetParent, (OMElement)sourceNode);
        } else if (sourceNode instanceof OMText) {
            AxiomUtils.copyOMText(factory, targetParent, (OMText)sourceNode);
        } else if (sourceNode instanceof OMComment) {
            AxiomUtils.copyOMComment(factory, targetParent, (OMComment)sourceNode);
        } else {
            throw new OMException("Internal Failure: Cannot make a copy of " + sourceNode.getClass().getName());
        }
    }

    public static void copyOMComment(SOAPFactory factory, OMContainer targetParent, OMComment sourceComment) {
        factory.createOMComment(targetParent, sourceComment.getValue());
    }

    public static void copyOMText(SOAPFactory factory, OMContainer targetParent, OMText sourceText) {
        if (sourceText.isBinary()) {
            sourceText.getDataHandler();
        }
        factory.createOMText(targetParent, sourceText);
    }

    public static void copyOMElement(SOAPFactory factory, OMContainer targetParent, OMElement sourceElement) {
        targetParent.addChild((OMNode)sourceElement.cloneOMElement());
    }

    public static void copyOMSourcedElement(SOAPFactory factory, OMContainer targetParent, OMSourcedElement sourceOMSE) {
        OMDataSource ds = sourceOMSE.getDataSource();
        if (ds == null || sourceOMSE.isExpanded() || !(ds instanceof OMDataSourceExt)) {
            AxiomUtils.copyOMElement(factory, targetParent, (OMElement)sourceOMSE);
            return;
        }
        OMDataSourceExt sourceDS = (OMDataSourceExt)ds;
        if (sourceDS.isDestructiveRead() || sourceDS.isDestructiveWrite()) {
            AxiomUtils.copyOMElement(factory, targetParent, (OMElement)sourceOMSE);
            return;
        }
        OMDataSourceExt targetDS = ((OMDataSourceExt)ds).copy();
        if (targetDS == null) {
            AxiomUtils.copyOMElement(factory, targetParent, (OMElement)sourceOMSE);
            return;
        }
        OMSourcedElement targetOMSE = factory.createOMElement((OMDataSource)targetDS, sourceOMSE.getLocalName(), sourceOMSE.getNamespace());
        targetParent.addChild((OMNode)targetOMSE);
    }

    public static void copySOAPHeaderBlock(SOAPFactory factory, OMContainer targetParent, SOAPHeaderBlock sourceSHB) {
        OMDataSource ds = sourceSHB.getDataSource();
        if (ds == null || sourceSHB.isExpanded() || !(ds instanceof OMDataSourceExt)) {
            AxiomUtils.copySOAPHeaderBlock_NoDataSource(factory, targetParent, sourceSHB);
            return;
        }
        OMDataSourceExt sourceDS = (OMDataSourceExt)ds;
        if (sourceDS.isDestructiveRead() || sourceDS.isDestructiveWrite()) {
            AxiomUtils.copySOAPHeaderBlock_NoDataSource(factory, targetParent, sourceSHB);
            return;
        }
        OMDataSourceExt targetDS = ((OMDataSourceExt)ds).copy();
        SOAPHeaderBlock targetSHB = factory.createSOAPHeaderBlock(sourceSHB.getLocalName(), sourceSHB.getNamespace(), (OMDataSource)targetDS);
        targetParent.addChild((OMNode)targetSHB);
        AxiomUtils.copySOAPHeaderBlockData(sourceSHB, targetSHB);
    }

    public static void copySOAPHeaderBlock_NoDataSource(SOAPFactory factory, OMContainer targetParent, SOAPHeaderBlock sourceSHB) {
        SOAPHeader header = (SOAPHeader)targetParent;
        String localName = sourceSHB.getLocalName();
        OMNamespace ns = sourceSHB.getNamespace();
        SOAPHeaderBlock targetSHB = factory.createSOAPHeaderBlock(localName, ns, header);
        AxiomUtils.copyTagData((OMElement)sourceSHB, (OMElement)targetSHB);
        AxiomUtils.copySOAPHeaderBlockData(sourceSHB, targetSHB);
        Iterator i = sourceSHB.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            AxiomUtils.copy(factory, (OMContainer)targetSHB, node);
        }
    }

    public static void copySOAPFault(SOAPFactory factory, OMContainer targetParent, SOAPFault sourceSOAPFault) {
        Exception e = sourceSOAPFault.getException();
        SOAPFault newSOAPFault = e == null ? factory.createSOAPFault((SOAPBody)targetParent) : factory.createSOAPFault((SOAPBody)targetParent, e);
        AxiomUtils.copyTagData((OMElement)sourceSOAPFault, (OMElement)newSOAPFault);
        Iterator i = sourceSOAPFault.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            AxiomUtils.copyFaultData(factory, newSOAPFault, node);
        }
    }

    public static void copyFaultData(SOAPFactory factory, SOAPFault targetFault, OMNode sourceNode) {
        if (sourceNode instanceof SOAPFaultCode) {
            AxiomUtils.copySOAPFaultCode(factory, targetFault, (SOAPFaultCode)sourceNode);
        } else if (sourceNode instanceof SOAPFaultDetail) {
            AxiomUtils.copySOAPFaultDetail(factory, targetFault, (SOAPFaultDetail)sourceNode);
        } else if (sourceNode instanceof SOAPFaultNode) {
            AxiomUtils.copySOAPFaultNode(factory, targetFault, (SOAPFaultNode)sourceNode);
        } else if (sourceNode instanceof SOAPFaultReason) {
            AxiomUtils.copySOAPFaultReason(factory, targetFault, (SOAPFaultReason)sourceNode);
        } else if (sourceNode instanceof SOAPFaultRole) {
            AxiomUtils.copySOAPFaultRole(factory, targetFault, (SOAPFaultRole)sourceNode);
        } else if (sourceNode instanceof OMText) {
            AxiomUtils.copyOMText(factory, (OMContainer)targetFault, (OMText)sourceNode);
        } else if (sourceNode instanceof OMComment) {
            AxiomUtils.copyOMComment(factory, (OMContainer)targetFault, (OMComment)sourceNode);
        } else {
            throw new OMException("Internal Failure: Cannot make a copy of " + sourceNode.getClass().getName() + " object found in a SOAPFault.");
        }
    }

    public static void copySOAPFaultRole(SOAPFactory factory, SOAPFault targetFault, SOAPFaultRole sourceRole) {
        SOAPFaultRole targetRole = factory.createSOAPFaultRole(targetFault);
        AxiomUtils.copyTagData((OMElement)sourceRole, (OMElement)targetRole);
        targetRole.setRoleValue(sourceRole.getRoleValue());
    }

    public static void copySOAPFaultNode(SOAPFactory factory, SOAPFault targetFault, SOAPFaultNode sourceNode) {
        SOAPFaultNode targetNode = factory.createSOAPFaultNode(targetFault);
        AxiomUtils.copyTagData((OMElement)sourceNode, (OMElement)targetNode);
        targetNode.setNodeValue(sourceNode.getNodeValue());
    }

    public static void copySOAPFaultDetail(SOAPFactory factory, SOAPFault targetFault, SOAPFaultDetail sourceDetail) {
        SOAPFaultDetail targetDetail = factory.createSOAPFaultDetail(targetFault);
        AxiomUtils.copyTagData((OMElement)sourceDetail, (OMElement)targetDetail);
        Iterator i = sourceDetail.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            AxiomUtils.copy(factory, (OMContainer)targetDetail, node);
        }
    }

    public static void copySOAPFaultReason(SOAPFactory factory, SOAPFault targetFault, SOAPFaultReason sourceReason) {
        SOAPFaultReason targetReason = factory.createSOAPFaultReason(targetFault);
        AxiomUtils.copyTagData((OMElement)sourceReason, (OMElement)targetReason);
        Iterator i = sourceReason.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            if (node instanceof SOAPFaultText) {
                SOAPFaultText oldText = (SOAPFaultText)node;
                SOAPFaultText newText = factory.createSOAPFaultText(targetReason);
                AxiomUtils.copyTagData((OMElement)oldText, (OMElement)newText);
                continue;
            }
            AxiomUtils.copy(factory, (OMContainer)targetReason, node);
        }
    }

    public static void copySOAPFaultCode(SOAPFactory factory, SOAPFault targetFault, SOAPFaultCode sourceCode) {
        SOAPFaultCode targetCode = factory.createSOAPFaultCode(targetFault);
        AxiomUtils.copyTagData((OMElement)sourceCode, (OMElement)targetCode);
        SOAPFaultValue sourceValue = sourceCode.getValue();
        SOAPFaultValue targetValue = factory.createSOAPFaultValue(targetCode);
        AxiomUtils.copyTagData((OMElement)sourceValue, (OMElement)targetValue);
        Iterator i = sourceValue.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            AxiomUtils.copy(factory, (OMContainer)targetValue, node);
        }
        SOAPFaultSubCode sourceSubCode = sourceCode.getSubCode();
        if (sourceSubCode != null) {
            AxiomUtils.copySOAPFaultSubCode(factory, (OMElement)targetCode, sourceSubCode);
        }
    }

    public static void copySOAPFaultSubCode(SOAPFactory factory, OMElement targetParent, SOAPFaultSubCode sourceSubCode) {
        SOAPFaultSubCode targetSubCode = targetParent instanceof SOAPFaultSubCode ? factory.createSOAPFaultSubCode((SOAPFaultSubCode)targetParent) : factory.createSOAPFaultSubCode((SOAPFaultCode)targetParent);
        AxiomUtils.copyTagData((OMElement)sourceSubCode, (OMElement)targetSubCode);
        SOAPFaultValue sourceValue = sourceSubCode.getValue();
        SOAPFaultValue targetValue = factory.createSOAPFaultValue(targetSubCode);
        AxiomUtils.copyTagData((OMElement)sourceValue, (OMElement)targetValue);
        Iterator i = sourceValue.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            AxiomUtils.copy(factory, (OMContainer)targetValue, node);
        }
        SOAPFaultSubCode sourceSubSubCode = sourceSubCode.getSubCode();
        if (sourceSubSubCode != null) {
            AxiomUtils.copySOAPFaultSubCode(factory, (OMElement)targetSubCode, sourceSubSubCode);
        }
    }

    public static void copyTagData(OMElement sourceElement, OMElement targetElement) {
        Iterator i = sourceElement.getAllDeclaredNamespaces();
        while (i.hasNext()) {
            OMNamespace ns = (OMNamespace)i.next();
            targetElement.declareNamespace(ns);
        }
        i = sourceElement.getAllAttributes();
        while (i.hasNext()) {
            OMAttribute attr = (OMAttribute)i.next();
            targetElement.addAttribute(attr);
        }
    }

    public static void copySOAPHeaderBlockData(SOAPHeaderBlock sourceSHB, SOAPHeaderBlock targetSHB) {
        if (sourceSHB.isProcessed()) {
            targetSHB.setProcessed();
        }
    }
}

