/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.XMLUtils;
import org.ow2.petals.binding.soap.util.AttachmentHelper;
import org.ow2.petals.binding.soap.util.AxiomSOAPEnvelopeFlattener;
import org.ow2.petals.binding.soap.util.SOAPFaultHelper;
import org.ow2.petals.binding.soap.util.StaxUtils;
import org.ow2.petals.commons.threadlocal.DocumentBuilders;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Marshaller {
    private static ThreadLocal<AxiomSOAPEnvelopeFlattener> flattener = new ThreadLocal<AxiomSOAPEnvelopeFlattener>(){

        @Override
        protected AxiomSOAPEnvelopeFlattener initialValue() {
            return new AxiomSOAPEnvelopeFlattener();
        }
    };

    private Marshaller() {
    }

    public static final void close() {
        flattener = null;
    }

    public static void copyAttachments(OMElement from, NormalizedMessage to) throws MessagingException {
        Iterator iter = from.getChildren();
        while (iter.hasNext()) {
            OMElement element;
            OMAttribute attr;
            OMNode node = (OMNode)iter.next();
            if (!(node instanceof OMElement) || (attr = (element = (OMElement)node).getAttribute(new QName("href"))) == null || !(node instanceof OMText) || !"Include".equalsIgnoreCase(element.getLocalName()) || !"http://www.w3.org/2004/08/xop/include".equalsIgnoreCase(element.getNamespace().getNamespaceURI())) continue;
            String attachmentId = attr.getAttributeValue().substring(4);
            OMText binaryNode = (OMText)node;
            DataHandler dh = (DataHandler)binaryNode.getDataHandler();
            to.addAttachment(attachmentId, dh);
        }
    }

    public static SOAPBody createSOAPBody(SOAPFactory factory, SOAPEnvelope envelope, Source source) throws AxisFault {
        SOAPBody body = null;
        try {
            XMLStreamReader parser = StaxUtils.createXMLStreamReader(source);
            StAXOMBuilder builder = new StAXOMBuilder((OMFactory)factory, parser);
            OMElement bodyContent = builder.getDocumentElement();
            body = factory.createSOAPBody(envelope);
            body.addChild((OMNode)bodyContent);
        }
        catch (Exception e) {
            throw new AxisFault("Error parsing the response from JBI service to a SOAPBody", "Server", (Throwable)e);
        }
        return body;
    }

    public static SOAPBody createSOAPBodyWithFault(SOAPFactory factory, SOAPEnvelope envelope, Source source) throws AxisFault {
        SOAPBody body = null;
        try {
            XMLStreamReader parser = StaxUtils.createXMLStreamReader(source);
            StAXOMBuilder builder = new StAXOMBuilder((OMFactory)factory, parser);
            OMElement bodyContent = builder.getDocumentElement();
            body = factory.createSOAPBody(envelope);
            SOAPFault soapFault = SOAPFaultHelper.createSOAPFault(factory, bodyContent);
            body.addFault(soapFault);
        }
        catch (Throwable t) {
            throw new AxisFault("Error parsing the fault from JBI service to a SOAPBody", "Server", t);
        }
        return body;
    }

    public static SOAPEnvelope createSOAPEnvelope(SOAPFactory factory, NormalizedMessage nm, boolean isJBIFault) throws AxisFault {
        Source source;
        Map protocolHeadersProperty = null;
        if (nm == null || nm.getContent() == null) {
            Document document = DocumentBuilders.getDefaultDocumentBuilder().newDocument();
            Element responseElement = document.createElement("Response");
            responseElement.setNodeValue("Done");
            document.appendChild(responseElement);
            source = UtilFactory.getSourceUtil().createDOMSource(document);
        } else {
            source = nm.getContent();
            Object protocolHeadersPropertyObject = nm.getProperty("javax.jbi.messaging.protocol.headers");
            if (protocolHeadersPropertyObject != null && protocolHeadersPropertyObject instanceof Map) {
                protocolHeadersProperty = (Map)protocolHeadersPropertyObject;
            }
        }
        SOAPEnvelope responseEnv = factory.createSOAPEnvelope();
        Marshaller.createSOAPHeader(factory, responseEnv, protocolHeadersProperty);
        if (!isJBIFault) {
            Marshaller.createSOAPBody(factory, responseEnv, source);
        } else {
            Marshaller.createSOAPBodyWithFault(factory, responseEnv, source);
        }
        return responseEnv;
    }

    private static void createSOAPHeader(SOAPFactory factory, SOAPEnvelope envelope, Map<String, DocumentFragment> protocolHeadersProperty) throws AxisFault {
        if (protocolHeadersProperty != null) {
            try {
                SOAPHeader header = factory.createSOAPHeader(envelope);
                for (DocumentFragment docfrag : protocolHeadersProperty.values()) {
                    Node node = docfrag.getFirstChild();
                    if (!(node instanceof Element)) continue;
                    header.addChild((OMNode)XMLUtils.toOM((Element)((Element)node)));
                }
            }
            catch (Exception e) {
                throw new AxisFault("Error parsing the response from JBI service to a SOAPHeader", "Server", (Throwable)e);
            }
        }
    }

    public static Source createSourceContent(SOAPEnvelope soapEnvelope, boolean axis1Compatibility) throws Exception {
        if (soapEnvelope == null) {
            throw new Exception("Envelope can not be null to create a source");
        }
        SOAPEnvelope envelope = axis1Compatibility ? Marshaller.multiRefToDocument(soapEnvelope) : soapEnvelope;
        return Marshaller.createSourceContent(envelope);
    }

    public static Source createSourceContentAndAttachment(MessageContext inContext) throws Exception {
        String charSetEncoding = (String)inContext.getProperty("CHARACTER_SET_ENCODING");
        PushbackInputStream pis = BuilderUtil.getPushbackInputStream((InputStream)inContext.getAttachmentMap().getSOAPPartInputStream());
        String actualCharSetEncoding = BuilderUtil.getCharSetEncoding((PushbackInputStream)pis, (String)charSetEncoding);
        XMLStreamReader streamReader = StAXUtils.createXMLStreamReader((InputStream)pis, (String)actualCharSetEncoding);
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(streamReader);
        SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
        return Marshaller.createSourceContent(envelope);
    }

    private static final Source createSourceContent(SOAPEnvelope envelope) throws XMLStreamException {
        StreamSource result = null;
        SOAPBody body = envelope.getBody();
        OMNamespace namespace = envelope.getNamespace();
        Iterator envNS = envelope.getAllDeclaredNamespaces();
        Iterator bodyNS = body.getAllDeclaredNamespaces();
        OMElement rootElement = body.getFirstElement();
        if (rootElement != null) {
            rootElement.declareNamespace(namespace);
            while (envNS.hasNext()) {
                rootElement.declareNamespace((OMNamespace)envNS.next());
            }
            while (bodyNS.hasNext()) {
                rootElement.declareNamespace((OMNamespace)bodyNS.next());
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            rootElement.serialize((OutputStream)os);
            result = new StreamSource(new ByteArrayInputStream(os.toByteArray()));
        }
        return result;
    }

    public static final void fillSOAPBodyWithAttachments(NormalizedMessage nm, SOAPFactory soapFactory, MessageContext messageContext) throws UnsupportedEncodingException {
        SOAPEnvelope env = messageContext.getEnvelope();
        if (nm.getAttachmentNames() != null && nm.getAttachmentNames().size() > 0) {
            SOAPBody body = env.getBody();
            if (body == null) {
                body = soapFactory.createSOAPBody(env);
            }
            OMNamespace omNs = soapFactory.createOMNamespace("http://petals.ow2.org/components/soap/version-4", "soapbc");
            OMElement rootElement = body.getFirstElement();
            if (rootElement == null) {
                rootElement = soapFactory.createOMElement("response", omNs, (OMContainer)body);
            }
            messageContext.setDoingMTOM(true);
            messageContext.setProperty("enableMTOM", (Object)"true");
            Set names = nm.getAttachmentNames();
            for (Object key : names) {
                DataHandler attachment = nm.getAttachment((String)key);
                OMElement attachRefElt = AttachmentHelper.hasAttachmentElement(rootElement, attachment, (String)key);
                if (attachRefElt == null) continue;
                OMElement firstElement = attachRefElt.getFirstChildWithName(new QName("http://www.w3.org/2004/08/xop/include", "Include"));
                if (firstElement == null) {
                    firstElement = attachRefElt.getFirstChildWithName(new QName("http://www.w3.org/2004/08/xop/include", "include"));
                }
                if (firstElement == null) continue;
                firstElement.detach();
                OMText attach = soapFactory.createOMText((Object)attachment, true);
                attachRefElt.addChild((OMNode)attach);
            }
        }
    }

    private static final SOAPEnvelope multiRefToDocument(SOAPEnvelope soapEnvelope) throws Exception {
        AxiomSOAPEnvelopeFlattener flattener = Marshaller.flattener.get();
        if (flattener == null) {
            throw new Exception("Can not get a valid flattener...");
        }
        return flattener.flatten(soapEnvelope);
    }

    public static void setAttachments(Attachments attachments, NormalizedMessage to) {
        if (to != null && attachments != null) {
            for (Object object : attachments.getContentIDSet()) {
                String id = (String)object;
                DataHandler dh = attachments.getDataHandler(id);
                if (dh.getContentType() != null && dh.getContentType().contains("soap+xml")) continue;
                try {
                    to.addAttachment(id, dh);
                }
                catch (MessagingException e) {}
            }
        }
    }

    public static void setProperties(MessageContext from, NormalizedMessage to) throws Exception {
        SOAPEnvelope env = from.getEnvelope();
        SOAPHeader header = env.getHeader();
        if (header != null) {
            Iterator elements = header.getChildElements();
            HashMap<String, DocumentFragment> soapHeaderElementsMap = new HashMap<String, DocumentFragment>();
            DocumentBuilder docBuilder = DocumentBuilders.getJvmDocumentBuilder();
            Document doc = docBuilder.newDocument();
            while (elements != null && elements.hasNext()) {
                OMElement element = (OMElement)elements.next();
                Element elt = XMLUtils.toDOM((OMElement)element);
                DocumentFragment docfrag = doc.createDocumentFragment();
                docfrag.appendChild(doc.importNode(elt, true));
                docfrag.normalize();
                soapHeaderElementsMap.put(element.getQName().toString(), docfrag);
            }
            to.setProperty("javax.jbi.messaging.protocol.headers", soapHeaderElementsMap);
        }
    }
}

