/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.jbi.adaptor.impl.AbstractJBIComponentTest;
import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedComponent;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestMessage;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedStatusFromConsumerMessage;
import java.net.SocketException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.FlowAttributes;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis2.util.Utils;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.binding.soap.axis.Axis2TestHelper;
import org.ow2.petals.component.api.Component;
import org.ow2.petals.component.api.ComponentConfiguration;
import org.ow2.petals.component.api.Message;
import org.ow2.petals.component.api.ServiceConfiguration;

public class SoapComponentTest
extends AbstractJBIComponentTest {
    private static final QName TEST_OPERATION = new QName("http://testProvideService", "get");
    private static final String SERVICE_NAMESPACE = "http://act.org/";
    private static final QName INTERFACE_QNAME = new QName("http://act.org/", "Echo");
    private static final QName SERVICE_QNAME = new QName("http://act.org/", "EchoService");
    private static final String OPERATION = "echoString";
    private static final QName EXPECTED_OPERATION_QNAME = new QName("http://act.org/", "echoString");
    private static final String EXPOSED_SERVICE_NAME = "testService";
    private static final String ENDPOINT_NAME = "Echo";
    private static final String HTTP_HOST;

    protected ComponentConfiguration createComponentConfiguration(Logger logger) {
        URL addressingMarUrl = Thread.currentThread().getContextClassLoader().getResource("addressing-1.5.6.mar");
        assert (addressingMarUrl != null);
        ComponentConfiguration componentConfiguration = super.createComponentConfiguration(logger);
        componentConfiguration.setParameter("{http://petals.ow2.org/components/soap/version-4}http-host", HTTP_HOST);
        componentConfiguration.setParameter("{http://petals.ow2.org/components/soap/version-4}http-port", String.valueOf(8084));
        componentConfiguration.setParameter("{http://petals.ow2.org/components/soap/version-4}http-services-context", "petals");
        componentConfiguration.setParameter("{http://petals.ow2.org/components/soap/version-4}http-services-mapping", "services");
        componentConfiguration.addResource(addressingMarUrl);
        return componentConfiguration;
    }

    public Component createComponentUnderTest(ComponentConfiguration componentConfiguration) {
        return new WrappedComponent(ComponentType.BC_SOAP, componentConfiguration);
    }

    public Message createMessageToProcessAsProvider(ServiceConfiguration testProvideServiceConfiguration) throws Exception {
        String payload = "<get />";
        return new WrappedRequestMessage(testProvideServiceConfiguration, TEST_OPERATION, AbsItfOperation.MEPPatternConstants.IN_OUT.value(), this.createPayloadInputStream(payload), new FlowAttributes("testFlowInstanceId", "testFlowStepId"));
    }

    public Message createTestStatusMessage(ServiceConfiguration testProvideServiceConfiguration, ExchangeStatus status) throws Exception {
        String payload = "";
        return new WrappedStatusFromConsumerMessage(testProvideServiceConfiguration, TEST_OPERATION, AbsItfOperation.MEPPatternConstants.IN_OUT.value(), this.createPayloadInputStream(payload), new FlowAttributes("testFlowInstanceId", "testFlowStepId"), status);
    }

    protected Map<String, String> generateExternalEvent() throws Exception {
        SOAPMessage soap11Message = SoapComponentTest.createTestSoap11Message(OPERATION, new String[0], new String[0]);
        String requestUrl = this.generateRequestedUrl(EXPOSED_SERVICE_NAME, HTTP_HOST);
        Axis2TestHelper.sendSoapMessageOverHttp(requestUrl, soap11Message);
        HashMap<String, String> specificParams = new HashMap<String, String>();
        specificParams.put("flowOperationName", EXPECTED_OPERATION_QNAME.toString());
        specificParams.put("requestedURL", requestUrl);
        return specificParams;
    }

    private static final SOAPMessage createTestSoap11Message(String soapBodyElementName, String[] attachmentContentIds, String[] textAttachmentsContent) {
        assert (attachmentContentIds.length == textAttachmentsContent.length);
        try {
            MessageFactory mf11 = MessageFactory.newInstance((String)"SOAP 1.1 Protocol");
            SOAPMessage message = mf11.createMessage();
            SOAPBody body = message.getSOAPBody();
            QName bodyName = new QName(soapBodyElementName);
            body.addBodyElement(bodyName);
            for (int i = 0; i < attachmentContentIds.length; ++i) {
                AttachmentPart attachment = message.createAttachmentPart();
                attachment.setContentId(attachmentContentIds[i]);
                attachment.setContent((Object)textAttachmentsContent[i], "text/plain");
                message.addAttachmentPart(attachment);
            }
            return message;
        }
        catch (SOAPException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    @Test(timeout=300000L)
    public void testProcessMessageAsConsumerLogsNothingBecauseMonitDisabled() throws Exception {
        this.componentUnderTest.start();
        ServiceConfiguration consumeServiceConfiguration = this.createTestConsumeServiceConfiguration();
        this.componentUnderTest.installService(consumeServiceConfiguration);
        ServiceConfiguration provideServiceConfiguration = this.createTestProvideServiceConfiguration();
        this.componentUnderTest.installService(provideServiceConfiguration);
        this.logger.setLevel(Level.INFO);
        this.generateExternalEvent();
        this.componentUnderTest.pollRequestToServer();
        List records = this.testHandler.getAllRecords(Level.MONIT);
        Assert.assertEquals((long)0L, (long)records.size());
    }

    protected ServiceConfiguration createTestConsumeServiceConfiguration() throws Exception {
        ServiceConfiguration testProvideServiceConguration = new ServiceConfiguration("testServiceConsume", INTERFACE_QNAME, SERVICE_QNAME, ENDPOINT_NAME, ServiceConfiguration.ServiceType.CONSUME);
        testProvideServiceConguration.setParameter("{http://petals.ow2.org/components/soap/version-4}service-name", EXPOSED_SERVICE_NAME);
        testProvideServiceConguration.setParameter("{http://petals.ow2.org/components/extensions/version-5}timeout", "1000");
        return testProvideServiceConguration;
    }

    protected ServiceConfiguration createTestProvideServiceConfiguration() throws Exception {
        URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource("sampleWsdl-1.wsdl");
        ServiceConfiguration testProvideServiceConguration = new ServiceConfiguration("testServiceProvide", INTERFACE_QNAME, SERVICE_QNAME, ENDPOINT_NAME, ServiceConfiguration.ServiceType.PROVIDE, wsdlUrl);
        testProvideServiceConguration.addResource(wsdlUrl);
        return testProvideServiceConguration;
    }

    private String generateRequestedUrl(String serviceName, String ipAddress) throws SocketException {
        return String.format("http://%s:%s/%s/%s/%s", ipAddress, 8084, "petals", "services", serviceName);
    }

    static {
        try {
            HTTP_HOST = Utils.getIpAddress();
        }
        catch (SocketException se) {
            throw new UncheckedException((Throwable)se);
        }
    }
}

