/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.axis;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;
import org.apache.axis2.dispatchers.RequestURIBasedDispatcher;
import org.apache.axis2.dispatchers.SOAPMessageBodyBasedDispatcher;
import org.apache.axis2.engine.DispatchPhase;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.transport.http.CommonsHTTPTransportSender;
import org.apache.axis2.transport.http.SimpleHTTPServer;
import org.ow2.petals.binding.soap.axis.Axis2Client;
import org.ow2.petals.binding.soap.axis.Axis2Config;
import org.ow2.petals.binding.soap.axis.Axis2Server;
import org.ow2.petals.binding.soap.axis.HandlerConfig;
import org.ow2.petals.binding.soap.axis.MessageReceiverConfig;
import org.ow2.petals.binding.soap.axis.PhaseConfig;
import org.ow2.petals.binding.soap.axis.PhaseOrderConfig;
import org.ow2.petals.binding.soap.axis.TransportReceiverConfig;
import org.ow2.petals.binding.soap.axis.TransportSenderConfig;

public class Axis2TestHelper {
    private static final Axis2Config createEmptyAxis2ConfigWithParameters() {
        Axis2Config axis2Config = new Axis2Config("axis2Config");
        axis2Config.addParameter("hotdeployment", "true");
        axis2Config.addParameter("hotupdate", "false");
        axis2Config.addParameter("contextRoot", "/");
        axis2Config.addParameter("servicePath", "services");
        return axis2Config;
    }

    private static final PhaseOrderConfig createMinimalInFlowPhaseOrder() {
        HandlerConfig requestURIBasedDispatcherConfig = new HandlerConfig("RequestURIBasedDispatcher", RequestURIBasedDispatcher.class);
        PhaseConfig transportPhaseConfig = new PhaseConfig("Transport");
        transportPhaseConfig.addHandler(requestURIBasedDispatcherConfig);
        PhaseConfig securityPhaseConfig = new PhaseConfig("Security");
        PhaseConfig preDispatchPhaseConfig = new PhaseConfig("PreDispatch");
        HandlerConfig soapMessageBodyBasedDispatcherConfig = new HandlerConfig("SOAPMessageBodyBasedDispatcher", SOAPMessageBodyBasedDispatcher.class);
        PhaseConfig dispatchPhaseConfig = new PhaseConfig("Dispatch", DispatchPhase.class);
        dispatchPhaseConfig.addHandler(soapMessageBodyBasedDispatcherConfig);
        PhaseOrderConfig inFlowConfig = new PhaseOrderConfig("InFlow");
        inFlowConfig.addPhase(transportPhaseConfig);
        inFlowConfig.addPhase(securityPhaseConfig);
        inFlowConfig.addPhase(preDispatchPhaseConfig);
        inFlowConfig.addPhase(dispatchPhaseConfig);
        return inFlowConfig;
    }

    private static final PhaseOrderConfig createMinimalInFaultFlowPhaseOrder() {
        PhaseConfig preDispatchPhaseConfig = new PhaseConfig("PreDispatch");
        HandlerConfig requestURIBasedDispatcherConfig = new HandlerConfig("RequestURIBasedDispatcher", RequestURIBasedDispatcher.class);
        PhaseConfig dispatchPhaseConfig = new PhaseConfig("Dispatch", DispatchPhase.class);
        dispatchPhaseConfig.addHandler(requestURIBasedDispatcherConfig);
        PhaseOrderConfig inFaultFlowConfig = new PhaseOrderConfig("InFaultFlow");
        inFaultFlowConfig.addPhase(preDispatchPhaseConfig);
        inFaultFlowConfig.addPhase(dispatchPhaseConfig);
        return inFaultFlowConfig;
    }

    public static final Axis2Server createMinimalAxis2Server(Class<? extends MessageReceiver> messageReceiverClass) {
        File tempDir;
        Axis2Config axis2Config = Axis2TestHelper.createEmptyAxis2ConfigWithParameters();
        for (String mepUri : new String[]{"http://www.w3.org/ns/wsdl/in-only", "http://www.w3.org/ns/wsdl/in-out"}) {
            axis2Config.addMessageReceiver(new MessageReceiverConfig(mepUri, messageReceiverClass));
        }
        TransportReceiverConfig httpServerReceiverConfig = new TransportReceiverConfig("http", SimpleHTTPServer.class);
        httpServerReceiverConfig.addParameter("port", "7899");
        axis2Config.addTransportReceiver(httpServerReceiverConfig);
        TransportSenderConfig httpSenderConfig = new TransportSenderConfig("http", CommonsHTTPTransportSender.class);
        httpSenderConfig.addParameter("Protocol", "HTTP/1.1");
        httpSenderConfig.addParameter("Transfer-Encoding", "chunked");
        axis2Config.addTransportSender(httpSenderConfig);
        axis2Config.addPhaseOrder(Axis2TestHelper.createMinimalInFlowPhaseOrder());
        axis2Config.addPhaseOrder(Axis2TestHelper.createMinimalInFaultFlowPhaseOrder());
        try {
            tempDir = FileSystemHelper.createTempDir();
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
        Axis2Server axis2Server = new Axis2Server(tempDir, axis2Config);
        return axis2Server;
    }

    public static final Axis2Client createMinimalAxis2Client(URL wsdlURL, QName wsdlServiceName, String portName, Logger logger) {
        File tempDir;
        Axis2Config axis2Config = Axis2TestHelper.createEmptyAxis2ConfigWithParameters();
        TransportSenderConfig httpSenderConfig = new TransportSenderConfig("http", CommonsHTTPTransportSender.class);
        httpSenderConfig.addParameter("Protocol", "HTTP/1.1");
        httpSenderConfig.addParameter("Transfer-Encoding", "chunked");
        axis2Config.addTransportSender(httpSenderConfig);
        axis2Config.addPhaseOrder(Axis2TestHelper.createMinimalInFlowPhaseOrder());
        axis2Config.addPhaseOrder(Axis2TestHelper.createMinimalInFaultFlowPhaseOrder());
        try {
            tempDir = FileSystemHelper.createTempDir();
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
        Axis2Client axis2Client = new Axis2Client(tempDir, axis2Config, wsdlURL, wsdlServiceName, portName, logger);
        return axis2Client;
    }

    public static final SOAPMessage sendSoapMessageOverHttp(String urlStr, SOAPMessage soapMessage) throws Exception {
        URL url = new URL(urlStr);
        SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection soapConnection = soapConnectionFactory.createConnection();
        SOAPMessage response = soapConnection.call(soapMessage, (Object)url);
        return response;
    }
}

