/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.binding.soap.BootStrapFileFilter;
import org.ow2.petals.binding.soap.SoapBootstrapOperations;
import org.ow2.petals.component.framework.DefaultBootstrap;

public class SoapBootstrap
extends DefaultBootstrap {
    protected SoapBootstrapOperations bootstrapOperations;
    public static final Logger logger = Logger.getLogger("org.apache.axis2");

    public String addModule(String url) throws Exception {
        return this.bootstrapOperations.addModule(url);
    }

    protected void copyConfigurationFiles() throws JBIException {
        File[] moduleFiles;
        String workspaceRootDir;
        File installRootFile = new File(this.getInstallContext().getInstallRoot());
        File axis2File = new File(installRootFile, "META-INF" + File.separator + "axis2.xml");
        if (axis2File.exists()) {
            workspaceRootDir = this.installContext.getContext().getWorkspaceRoot();
            File destFile = new File(workspaceRootDir, axis2File.getName());
            if (!destFile.exists()) {
                try {
                    FileUtils.copyFile((File)axis2File, (File)destFile);
                }
                catch (IOException e) {
                    throw new JBIException("Can not copy the axis2 configuration file, axis2 can not be used", (Throwable)e);
                }
            }
        } else {
            throw new JBIException("the axis2 configuration file do not exist at '+ " + axis2File.getAbsolutePath() + "', axis2 can not be used");
        }
        workspaceRootDir = this.getInstallContext().getContext().getWorkspaceRoot();
        File modules = new File(workspaceRootDir, "modules");
        for (File file : moduleFiles = installRootFile.listFiles(new BootStrapFileFilter())) {
            File destFile = new File(modules, file.getName());
            if (destFile.exists()) continue;
            try {
                FileUtils.copyFile((File)file, (File)destFile);
            }
            catch (IOException e) {
                this.getLogger().warning("The module '" + file.getName() + "' can not been copied to modules directory");
            }
        }
    }

    protected void createWorkDirectories() {
        String workspaceRootDir = this.installContext.getContext().getWorkspaceRoot();
        File modules = new File(workspaceRootDir, "modules");
        File services = new File(workspaceRootDir, "services");
        if (!modules.exists() && !modules.mkdirs()) {
            this.getLogger().warning("Cannot create modules directory at '" + modules.getAbsolutePath() + "'");
        }
        if (!services.exists() && !services.mkdirs()) {
            this.getLogger().warning("Cannot create services directory at '" + services.getAbsolutePath() + "'");
        }
    }

    protected void doInit() throws JBIException {
        super.doInit();
        this.createWorkDirectories();
        this.copyConfigurationFiles();
        logger.setLevel(Level.OFF);
        if (this.bootstrapOperations == null) {
            this.bootstrapOperations = new SoapBootstrapOperations(this.installContext);
        }
    }

    protected List<String> getAttributeList() {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("httpPort");
        attributes.add("httpHostName");
        attributes.add("httpServicesList");
        attributes.add("httpServicesContext");
        attributes.add("httpServicesMapping");
        attributes.add("httpThreadPoolSizeMin");
        attributes.add("httpThreadPoolSizeMax");
        attributes.add("httpAcceptors");
        attributes.add("httpsEnabled");
        attributes.add("httpsPort");
        attributes.add("httpsKeystoreType");
        attributes.add("httpsKeystoreFile");
        attributes.add("httpsKeystorePassword");
        attributes.add("httpsKeyPassword");
        attributes.add("httpsTruststoreType");
        attributes.add("httpsTruststoreFile");
        attributes.add("httpsTruststorePassword");
        attributes.add("javaNamingFactoryInitial");
        attributes.add("javaNamingProviderURL");
        attributes.add("jmsConnectionFactoryJNDIName");
        return attributes;
    }

    public int getHttpAcceptors() {
        int httpAcceptors = 0;
        String httpAcceptorsString = this.bootstrapOperations.getParam("http-acceptors", this.getJbiComponentConfiguration());
        if (httpAcceptorsString != null) {
            httpAcceptors = Integer.parseInt(httpAcceptorsString);
        }
        return httpAcceptors;
    }

    public String getHttpHostName() {
        return this.bootstrapOperations.getParam("http-host", this.getJbiComponentConfiguration());
    }

    public int getHttpPort() {
        int httpPort = 0;
        String httpPortString = this.bootstrapOperations.getParam("http-port", this.getJbiComponentConfiguration());
        if (httpPortString != null) {
            httpPort = Integer.parseInt(httpPortString);
        }
        return httpPort;
    }

    public String getHttpServicesContext() {
        return this.bootstrapOperations.getParam("http-services-context", this.getJbiComponentConfiguration());
    }

    public boolean getHttpServicesList() {
        boolean httpServicesList = true;
        String httpServicesListString = this.bootstrapOperations.getParam("http-services-list", this.getJbiComponentConfiguration());
        if (httpServicesListString != null) {
            httpServicesList = Boolean.parseBoolean(httpServicesListString);
        }
        return httpServicesList;
    }

    public String getHttpServicesMapping() {
        return this.bootstrapOperations.getParam("http-services-mapping", this.getJbiComponentConfiguration());
    }

    public int getHttpThreadPoolSizeMax() {
        int httpThreadPoolSizeMax = 0;
        String httpThreadPoolSizeMaxString = this.bootstrapOperations.getParam("http-thread-pool-size-max", this.getJbiComponentConfiguration());
        if (httpThreadPoolSizeMaxString != null) {
            httpThreadPoolSizeMax = Integer.parseInt(httpThreadPoolSizeMaxString);
        }
        return httpThreadPoolSizeMax;
    }

    public int getHttpThreadPoolSizeMin() {
        int httpThreadPoolSizeMin = 0;
        String httpThreadPoolSizeMinString = this.bootstrapOperations.getParam("http-thread-pool-size-min", this.getJbiComponentConfiguration());
        if (httpThreadPoolSizeMinString != null) {
            httpThreadPoolSizeMin = Integer.parseInt(httpThreadPoolSizeMinString);
        }
        return httpThreadPoolSizeMin;
    }

    public String getJavaNamingFactoryInitial() {
        return this.bootstrapOperations.getParam("java-naming-factory-initial", this.getJbiComponentConfiguration());
    }

    public String getJavaNamingProviderURL() {
        return this.bootstrapOperations.getParam("java-naming-provider-url", this.getJbiComponentConfiguration());
    }

    public String getJMSConnectionFactoryJNDIName() {
        return this.bootstrapOperations.getParam("jms-connection-factory-jndiname", this.getJbiComponentConfiguration());
    }

    public boolean isHttpsEnabled() {
        boolean isHttpsEnabled = false;
        String isHttpsEnabledString = this.bootstrapOperations.getParam("https-enabled", this.getJbiComponentConfiguration());
        if (isHttpsEnabledString != null) {
            isHttpsEnabled = Boolean.parseBoolean(isHttpsEnabledString);
        }
        return isHttpsEnabled;
    }

    public String getHttpsKeystoreType() {
        return this.bootstrapOperations.getParam("https-keystore-type", this.getJbiComponentConfiguration());
    }

    public int getHttpsPort() {
        int httpsPort = 0;
        String httpsPortString = this.bootstrapOperations.getParam("https-port", this.getJbiComponentConfiguration());
        if (httpsPortString != null) {
            httpsPort = Integer.parseInt(httpsPortString);
        }
        return httpsPort;
    }

    public String getHttpsKeystoreFile() {
        return this.bootstrapOperations.getParam("https-keystore-file", this.getJbiComponentConfiguration());
    }

    public String getHttpsKeystorePassword() {
        return this.bootstrapOperations.getParam("https-keystore-password", this.getJbiComponentConfiguration());
    }

    public String getHttpsKeyPassword() {
        return this.bootstrapOperations.getParam("https-key-password", this.getJbiComponentConfiguration());
    }

    public String getHttpsTruststoreType() {
        return this.bootstrapOperations.getParam("https-truststore-type", this.getJbiComponentConfiguration());
    }

    public String getHttpsTruststoreFile() {
        return this.bootstrapOperations.getParam("https-truststore-file", this.getJbiComponentConfiguration());
    }

    public String getHttpsTruststorePassword() {
        return this.bootstrapOperations.getParam("https-truststore-password", this.getJbiComponentConfiguration());
    }

    protected List<String> getMethodList() {
        ArrayList<String> methods = new ArrayList<String>();
        methods.add("addModule");
        return methods;
    }

    public void setHttpAcceptors(int httpAcceptors) {
        this.bootstrapOperations.setParam("http-acceptors", Integer.toString(httpAcceptors), this.getJbiComponentConfiguration());
    }

    public void setHttpHostName(String httpHostName) {
        this.bootstrapOperations.setParam("http-host", httpHostName, this.getJbiComponentConfiguration());
    }

    public void setHttpPort(int httpPort) {
        this.bootstrapOperations.setParam("http-port", Integer.toString(httpPort), this.getJbiComponentConfiguration());
    }

    public void setHttpServicesContext(String httpServicesContext) {
        this.bootstrapOperations.setParam("http-services-context", httpServicesContext, this.getJbiComponentConfiguration());
    }

    public void setHttpServicesList(boolean httpServicesList) {
        this.bootstrapOperations.setParam("http-services-list", Boolean.toString(httpServicesList), this.getJbiComponentConfiguration());
    }

    public void setHttpServicesMapping(String httpServicesMapping) {
        this.bootstrapOperations.setParam("http-services-mapping", httpServicesMapping, this.getJbiComponentConfiguration());
    }

    public void setHttpThreadPoolSizeMax(int httpThreadPoolSizeMax) {
        this.bootstrapOperations.setParam("http-thread-pool-size-max", Integer.toString(httpThreadPoolSizeMax), this.getJbiComponentConfiguration());
    }

    public void setHttpThreadPoolSizeMin(int httpThreadPoolSizeMin) {
        this.bootstrapOperations.setParam("http-thread-pool-size-min", Integer.toString(httpThreadPoolSizeMin), this.getJbiComponentConfiguration());
    }

    public void setJavaNamingFactoryInitial(String javaNamingFactoryInitial) {
        this.bootstrapOperations.setParam("java-naming-factory-initial", javaNamingFactoryInitial, this.getJbiComponentConfiguration());
    }

    public void setJavaNamingProviderURL(String javaNamingProviderURL) {
        this.bootstrapOperations.setParam("java-naming-provider-url", javaNamingProviderURL, this.getJbiComponentConfiguration());
    }

    public void setJMSConnectionFactoryJNDIName(String jmsConnectionFactoryJNDIName) {
        this.bootstrapOperations.setParam("jms-connection-factory-jndiname", jmsConnectionFactoryJNDIName, this.getJbiComponentConfiguration());
    }

    public void setHttpsEnabled(boolean isHttpsEnabled) {
        this.bootstrapOperations.setParam("https-enabled", Boolean.toString(isHttpsEnabled), this.getJbiComponentConfiguration());
    }

    public void setHttpsPort(int httpsPort) {
        this.bootstrapOperations.setParam("https-port", Integer.toString(httpsPort), this.getJbiComponentConfiguration());
    }

    public void setHttpsKeystoreType(String httpsKeystoreType) {
        this.bootstrapOperations.setParam("https-keystore-type", httpsKeystoreType, this.getJbiComponentConfiguration());
    }

    public void setHttpsKeystoreFile(String httpsKeytoreFile) {
        this.bootstrapOperations.setParam("https-keystore-file", httpsKeytoreFile, this.getJbiComponentConfiguration());
    }

    public void setHttpsKeystorePassword(String httpsKeytorePassword) {
        this.bootstrapOperations.setParam("https-keystore-password", httpsKeytorePassword, this.getJbiComponentConfiguration());
    }

    public void setHttpsKeyPassword(String httpsKeytoreKeyPassword) {
        this.bootstrapOperations.setParam("https-key-password", httpsKeytoreKeyPassword, this.getJbiComponentConfiguration());
    }

    public void setHttpsTruststoreType(String httpsTruststoreType) {
        this.bootstrapOperations.setParam("https-truststore-type", httpsTruststoreType, this.getJbiComponentConfiguration());
    }

    public void setHttpsTruststoreFile(String httpsTruststoreFile) {
        this.bootstrapOperations.setParam("https-truststore-file", httpsTruststoreFile, this.getJbiComponentConfiguration());
    }

    public void setHttpsTruststorePassword(String httpsTruststorePassword) {
        this.bootstrapOperations.setParam("https-truststore-password", httpsTruststorePassword, this.getJbiComponentConfiguration());
    }
}

