/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.axis;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.File;
import java.util.logging.Logger;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.ListenerManager;
import org.ow2.petals.binding.soap.axis.AbstractAxis2RepositoryBasedObject;
import org.ow2.petals.binding.soap.axis.Axis2Config;
import org.ow2.petals.binding.soap.axis.ServiceConfig;

public class Axis2Server
extends AbstractAxis2RepositoryBasedObject {
    private static final Logger log = Logger.getLogger("Petals.Container.Components.petals-bc-soap");
    private ListenerManager listenerManager = null;

    public Axis2Server(File baseDir, Axis2Config config) {
        super(baseDir, config);
    }

    public void start() {
        log.fine(String.format("Starting Axis2 instance using '%s' as base directory.", this.getBaseDir()));
        this.listenerManager = new ListenerManager();
        this.listenerManager.init(this.getConfigurationContext());
        this.listenerManager.start();
    }

    public void stop() {
        log.fine(String.format("Stopping Axis2 instance having '%s' as base directory.", this.getBaseDir()));
        assert (this.listenerManager != null) : "Cannot stop an Axis2 instance which is not started!";
        if (this.listenerManager.isStopped()) {
            return;
        }
        try {
            this.listenerManager.stop();
        }
        catch (AxisFault e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public void deployService(ServiceConfig serviceConfig) {
        assert (this.isSetUp()) : "Axis2 instance must first be set up before deploying a service.";
        assert (this.listenerManager == null) : "Hot deploying a service after Axis2 server is started is not supported right now.";
        this.getRepository().deployService(serviceConfig);
    }
}

