/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import com.ebmwebsourcing.easycommons.uuid.QualifiedUUIDGenerator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.RobustOutOnlyAxisOperation;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.http.CommonsHTTPTransportSender;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.contrib.ssl.AuthSSLProtocolSocketFactory;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.ow2.petals.binding.soap.ServiceContext;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.binding.soap.listener.outgoing.Axis1SOAPFaultHTTPTransportSender;
import org.ow2.petals.binding.soap.listener.outgoing.PetalsServiceClient;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;

public class ServiceClientPoolObjectFactory
extends BasePoolableObjectFactory {
    private final String address;
    private final QName operation;
    private final URI mep;
    private final ConfigurationExtensions extensions;
    private final SoapComponentContext soapContext;
    private final Provides provides;
    private final Logger logger;
    private final String soapAction;

    private Options createOptions(String address, String soapAction, ConfigurationExtensions extensions) throws MessagingException, GeneralSecurityException, IOException {
        Long timeout;
        Options options = new Options();
        options.setTo(new EndpointReference(address));
        options.setProperty("messageType", (Object)"application/soap+xml");
        if (!SUPropertiesHelper.isWSAEnabled(extensions)) {
            options.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
        }
        if (soapAction != null) {
            options.setAction(soapAction);
        }
        if ((timeout = this.provides.getTimeout()) != null) {
            options.setTimeOutInMilliSeconds(timeout.longValue());
        }
        String soapEnvelopeNamespaceURI = SUPropertiesHelper.retrieveSOAPEnvelopeNamespaceURI(extensions);
        options.setSoapVersionURI(soapEnvelopeNamespaceURI);
        this.setTransport(address, extensions, options);
        HttpTransportProperties.ProxyProperties proxyProperties = SUPropertiesHelper.retrieveProxySettings(extensions);
        if (proxyProperties != null) {
            options.setProperty("PROXY", (Object)proxyProperties);
        }
        options.setExceptionToBeThrownOnSOAPFault(false);
        options.setCallTransportCleanup(SUPropertiesHelper.retrieveCleanupTransport(extensions));
        SUPropertiesHelper.setBasicAuthentication(extensions, options);
        return options;
    }

    private final void setTransport(String address, ConfigurationExtensions extensions, Options options) throws MessagingException, GeneralSecurityException, IOException {
        Axis1SOAPFaultHTTPTransportSender sender;
        TransportOutDescription transportOutDescription;
        block23: {
            URI uri = URI.create(address);
            String scheme = uri.getScheme();
            String transport = null;
            transport = scheme == null ? "http" : scheme;
            if (transport.equals("http")) {
                options.setTransportInProtocol("http");
                transportOutDescription = new TransportOutDescription("http");
                if (SUPropertiesHelper.isAxis1CompatibilityEnabled(extensions)) {
                    sender = new Axis1SOAPFaultHTTPTransportSender();
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "Set the customized Axis 2 transport sender: " + ((Object)((Object)sender)).getClass().getName());
                    }
                } else {
                    sender = new CommonsHTTPTransportSender();
                }
            } else if (transport.equals("https")) {
                int port;
                EasySSLProtocolSocketFactory socketFactory;
                options.setTransportInProtocol("https");
                transportOutDescription = new TransportOutDescription("https");
                sender = new CommonsHTTPTransportSender();
                URL keystoreURL = null;
                String keystorePassword = null;
                String keystoreFileStr = SUPropertiesHelper.getKeystoreFile(extensions);
                if (keystoreFileStr != null) {
                    try {
                        File keystoreFile = new File(keystoreFileStr);
                        keystoreURL = keystoreFile.toURI().toURL();
                        if (this.logger.isLoggable(Level.INFO)) {
                            this.logger.log(Level.INFO, "Client authentication is enabled.");
                        }
                    }
                    catch (MalformedURLException e) {
                        throw new MessagingException("The keystore URL is not correct: " + e.getMessage());
                    }
                    keystorePassword = SUPropertiesHelper.getKeystorePassword(extensions);
                }
                URL truststoreURL = null;
                String truststorePassword = null;
                String truststoreFileStr = SUPropertiesHelper.getTruststoreFile(extensions);
                if (truststoreFileStr != null) {
                    try {
                        File truststoreFile = new File(truststoreFileStr);
                        truststoreURL = truststoreFile.toURI().toURL();
                        if (this.logger.isLoggable(Level.INFO)) {
                            this.logger.log(Level.INFO, "Server authentication is enabled.");
                        }
                    }
                    catch (MalformedURLException e) {
                        throw new MessagingException("The truststore URL is not correct: " + e.getMessage());
                    }
                    truststorePassword = SUPropertiesHelper.getTruststorePassword(extensions);
                }
                if (truststoreURL == null && keystoreURL == null) {
                    socketFactory = new EasySSLProtocolSocketFactory();
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.log(Level.WARNING, "Client and server authentications are disabled.");
                    }
                } else {
                    socketFactory = new AuthSSLProtocolSocketFactory(keystoreURL, keystorePassword, truststoreURL, truststorePassword);
                }
                if ((port = uri.getPort()) == -1) {
                    port = 443;
                }
                Protocol protocolHandler = new Protocol("https", (ProtocolSocketFactory)socketFactory, port);
                options.setProperty("CUSTOM_PROTOCOL_HANDLER", (Object)protocolHandler);
            } else {
                throw new NotImplementedException("Transport protocol not supported.");
            }
            try {
                transportOutDescription.addParameter(new Parameter("PROTOCOL", (Object)"HTTP/1.1"));
            }
            catch (AxisFault af) {
                if (!this.logger.isLoggable(Level.WARNING)) break block23;
                this.logger.log(Level.WARNING, "Can not set the http PROTOCOL parameter: " + af.getMessage());
            }
        }
        try {
            sender.init(this.soapContext.getAxis2ConfigurationContext(), transportOutDescription);
        }
        catch (AxisFault e) {
            throw new MessagingException("Can not initialiaze the transport sender: " + e.getMessage());
        }
        transportOutDescription.setSender((TransportSender)sender);
        options.setTransportOut(transportOutDescription);
        options.setProperty("__CHUNKED__", (Object)SUPropertiesHelper.retrieveChunkedMode(extensions));
    }

    public ServiceClientPoolObjectFactory(String address, QName operation, URI mep, ConfigurationExtensions extensions, SoapComponentContext context, Provides provides, Logger logger, String soapAction) {
        this.address = address;
        this.operation = operation;
        this.soapAction = soapAction;
        this.mep = mep;
        this.extensions = extensions;
        this.soapContext = context;
        this.provides = provides;
        this.logger = logger;
    }

    protected void engageModule(PetalsServiceClient petalsServiceClient, String moduleName) throws AxisFault {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Engaging module " + moduleName);
        }
        petalsServiceClient.engageModule(moduleName);
    }

    private void engageModules(PetalsServiceClient petalsServiceClient) throws AxisFault {
        List<String> modules = this.soapContext.getProvidersManager().getServiceContext(this.provides).getModules();
        if (modules != null) {
            for (String name : modules) {
                this.engageModule(petalsServiceClient, name);
            }
        }
    }

    public Object makeObject() throws MessagingException, AxisFault, GeneralSecurityException, IOException {
        Options options;
        AxisService axisService;
        block7: {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Creating a service client for : " + this.address + ", with operation '" + this.operation + "', and MEP '" + this.mep + "'");
            }
            axisService = new AxisService("OutgoingWSClient" + new QualifiedUUIDGenerator("petals:uid").getNewID());
            SoapComponentContext.ServiceManager<Provides> providersManager = this.soapContext.getProvidersManager();
            ServiceContext<Provides> serviceContext = providersManager.getServiceContext(this.provides);
            ClassLoader cl = serviceContext.getClassloader();
            axisService.setClassLoader(cl);
            Object axisOperation = Message.MEPConstants.IN_ONLY_PATTERN.equals(this.mep) ? new OutOnlyAxisOperation(this.operation) : (Message.MEPConstants.ROBUST_IN_ONLY_PATTERN.equals(this.mep) ? new RobustOutOnlyAxisOperation(this.operation) : (Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN.equals(this.mep) || Message.MEPConstants.IN_OUT_PATTERN.equals(this.mep) ? new OutInAxisOperation(this.operation) : null));
            axisService.addOperation((AxisOperation)axisOperation);
            options = this.createOptions(this.address, this.soapAction, this.extensions);
            try {
                providersManager.addServiceParameters(this.provides, axisService);
            }
            catch (XMLStreamException e) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.warning(e.getMessage());
                }
            }
            catch (DeploymentException e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block7;
                this.logger.warning(e.getMessage());
            }
        }
        try {
            PetalsServiceClient petalsServiceClient = new PetalsServiceClient(this.soapContext.getAxis2ConfigurationContext(), axisService);
            petalsServiceClient.setOptions(options);
            this.engageModules(petalsServiceClient);
            return petalsServiceClient;
        }
        catch (AxisFault e) {
            throw new MessagingException("Can't create ServiceClient", (Throwable)e);
        }
    }
}

