/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolUtils;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.mbean.RuntimeConfigurationNotifier;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.JBIProcessorManagerObservable;
import org.ow2.petals.component.framework.process.MessageExchangeProcessor;

public class JBIProcessorManager
extends JBIProcessorManagerObservable {
    private ThreadPoolExecutor processorPool = null;
    protected GenericObjectPool objectPool = null;
    protected AbstractComponent component;
    private final RuntimeConfigurationNotifier runtimeConfiguration;
    protected Logger logger;

    public JBIProcessorManager(AbstractComponent component, RuntimeConfigurationNotifier runtimeConfiguration, Logger logger) {
        this.component = component;
        this.runtimeConfiguration = runtimeConfiguration;
        this.logger = logger;
        this.runtimeConfiguration.addNotificationListener(new RuntimeConfigurationListener(), null, null);
    }

    public void start() throws JBIException {
        this.logger.fine("Creating JBI Processor pool, core pool size is " + this.component.getComponentConfiguration().getProcessorPoolSize().getValue());
        int maxProcessorPoolSize = 50;
        if (this.component.getComponentConfiguration().getProcessorMaxPoolSize() != null) {
            maxProcessorPoolSize = this.component.getComponentConfiguration().getProcessorMaxPoolSize().getValue().intValue();
        }
        this.objectPool = new GenericObjectPool((PoolableObjectFactory)new MessageExchangeProcessorObjectFactory(), maxProcessorPoolSize);
        try {
            PoolUtils.prefill((ObjectPool)this.objectPool, (int)this.component.getComponentConfiguration().getProcessorPoolSize().getValue().intValue());
        }
        catch (IllegalArgumentException e) {
            throw new JBIException((Throwable)e);
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
        this.processorPool = new MessageExchangeProcessorThreadPoolExecutor(this.component.getComponentConfiguration().getProcessorPoolSize().getValue().intValue(), maxProcessorPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new JBIProcessorThreadFactory());
        this.processorPool.prestartAllCoreThreads();
    }

    public void stop() {
        this.processorPool.shutdown();
        try {
            long processorStopMaxWait = 15000L;
            if (this.component.getComponentConfiguration().getProcessorStopMaxWait() != null) {
                processorStopMaxWait = this.component.getComponentConfiguration().getProcessorStopMaxWait().getValue();
            }
            this.processorPool.awaitTermination(processorStopMaxWait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Workers pool interrupted : " + e.getMessage());
        }
        this.processorPool.shutdownNow();
        try {
            this.objectPool.close();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed to close the Messsage Exchange Processor Object pool properly", e);
        }
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.processorPool;
    }

    public GenericObjectPool getObjectPool() {
        return this.objectPool;
    }

    private void setCorePoolSize(int size) {
        this.logger.info("Reset the processor thread pool size to " + size);
        this.processorPool.setCorePoolSize(size);
    }

    private void setMaxCorePoolSize(int size) {
        this.logger.info("Reset the maximum processor thread pool size to " + size);
        this.processorPool.setMaximumPoolSize(size);
    }

    private class MessageExchangeProcessorObjectFactory
    implements PoolableObjectFactory {
        private MessageExchangeProcessorObjectFactory() {
        }

        public void activateObject(Object arg0) throws Exception {
        }

        public void destroyObject(Object arg0) throws Exception {
        }

        public Object makeObject() throws Exception {
            AbstractJBIListener jbiListener = this.createAndInitJBIListener();
            MessageExchangeProcessor jbiProcessor = new MessageExchangeProcessor(JBIProcessorManager.this.component, jbiListener, JBIProcessorManager.this.logger);
            return jbiProcessor;
        }

        public void passivateObject(Object arg0) throws Exception {
        }

        public boolean validateObject(Object arg0) {
            return true;
        }

        private AbstractJBIListener createAndInitJBIListener() throws PEtALSCDKException {
            AbstractJBIListener jbiListener = null;
            String jbiListenerClassNameValue = JBIProcessorManager.this.component.getComponentConfiguration().getJbiListenerClassName();
            String jbiListenerClassName = jbiListenerClassNameValue.replaceAll("\\s", "");
            if (!StringHelper.isNullOrEmpty((String)jbiListenerClassName)) {
                try {
                    ClassLoader componentClassLoader = this.getClass().getClassLoader();
                    Class<?> clazz = componentClassLoader.loadClass(jbiListenerClassName);
                    jbiListener = (AbstractJBIListener)clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new PEtALSCDKException("Can't instanciate JBIListener : " + jbiListenerClassName, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new PEtALSCDKException("Can't instanciate JBIListener : " + jbiListenerClassName, (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    throw new PEtALSCDKException("Can't find JBIListener class : " + jbiListenerClassName, (Throwable)e);
                }
            } else {
                throw new PEtALSCDKException("JBIListener class name can not be empty");
            }
            jbiListener.init(JBIProcessorManager.this.component);
            jbiListener.init();
            return jbiListener;
        }
    }

    private class MessageExchangeProcessorThreadPoolExecutor
    extends ThreadPoolExecutor {
        public MessageExchangeProcessorThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
            ExchangeImpl exchange = ((MessageExchangeProcessor)r).getMessageExchange();
            JBIProcessorManager.this.notifyObserversBeforeProcessing(exchange);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            ExchangeImpl exchange = ((MessageExchangeProcessor)r).getMessageExchange();
            JBIProcessorManager.this.notifyObserversAfterProcessing(exchange);
            ((MessageExchangeProcessor)r).clean();
            try {
                JBIProcessorManager.this.objectPool.returnObject((Object)r);
            }
            catch (Exception e) {
                JBIProcessorManager.this.logger.log(Level.SEVERE, "Failed to return a Message Exchange Processor instance to the Object pool", e);
            }
            super.afterExecute(r, t);
        }
    }

    private class JBIProcessorThreadFactory
    implements ThreadFactory {
        final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String componentName;

        public JBIProcessorThreadFactory() {
            this.componentName = JBIProcessorManager.this.component.getComponentConfiguration().getIdentification().getName();
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.componentName + " - MessageExchange Processor thread #" + Integer.toString(this.threadNumber.getAndIncrement());
            JBIProcessorManager.this.logger.log(Level.FINE, "Creating new JBI Processor Thread : " + name);
            return new Thread(Thread.currentThread().getThreadGroup(), r, name);
        }
    }

    private class RuntimeConfigurationListener
    implements NotificationListener {
        private RuntimeConfigurationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object obj) {
            if (notification instanceof AttributeChangeNotification) {
                AttributeChangeNotification attrNotif = (AttributeChangeNotification)notification;
                JBIProcessorManager.this.logger.log(Level.FINE, "Notification received for attribute : " + attrNotif.getAttributeName());
                if (attrNotif.getAttributeName().equals("processorPoolSize")) {
                    Integer newVal = (Integer)attrNotif.getNewValue();
                    JBIProcessorManager.this.setCorePoolSize(newVal);
                } else if (attrNotif.getAttributeName().equals("processorMaxPoolSize")) {
                    Integer newVal = (Integer)attrNotif.getNewValue();
                    JBIProcessorManager.this.setMaxCorePoolSize(newVal);
                }
            }
        }
    }
}

