/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import com.ebmwebsourcing.easycommons.logger.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import org.ow2.petals.commons.logger.ConsumeFlowStepEndLogData;
import org.ow2.petals.commons.logger.ConsumeFlowStepFailureLogData;
import org.ow2.petals.commons.logger.ProvideFlowStepEndLogData;
import org.ow2.petals.commons.logger.ProvideFlowStepFailureLogData;
import org.ow2.petals.component.framework.api.message.Exchange;

public final class LoggingUtil {
    private static final String ERROR_MESSAGE_LINE_SEPARATOR = " - ";
    private static final String BUSINESS_ERROR_MESSAGE = "A business error occurs";
    private static final String UNKNOWN_ERROR_MESSAGE = "A unknown error occurs (%s)";

    private LoggingUtil() {
    }

    public static final void addMonitEndOrFailureTrace(Logger logger, Exchange exchange, FlowAttributes flowAttributes) {
        Object flowLogData;
        String flowInstanceId = null;
        String flowStepId = null;
        if (flowAttributes != null) {
            flowInstanceId = flowAttributes.getFlowInstanceId();
            flowStepId = flowAttributes.getFlowStepId();
        }
        if (!exchange.isErrorStatus() && exchange.getFault() == null) {
            flowLogData = exchange.isConsumerRole() ? new ConsumeFlowStepEndLogData(flowInstanceId, flowStepId) : new ProvideFlowStepEndLogData(flowInstanceId, flowStepId);
        } else {
            String failureMessage;
            if (exchange.isErrorStatus()) {
                Exception error = exchange.getError();
                assert (error != null);
                String message = error.getMessage();
                failureMessage = message != null ? message.replace("\n", ERROR_MESSAGE_LINE_SEPARATOR) : String.format(UNKNOWN_ERROR_MESSAGE, error.getStackTrace()[0].toString());
            } else {
                failureMessage = BUSINESS_ERROR_MESSAGE;
            }
            flowLogData = exchange.isConsumerRole() ? new ConsumeFlowStepFailureLogData(flowInstanceId, flowStepId, failureMessage) : new ProvideFlowStepFailureLogData(flowInstanceId, flowStepId, failureMessage);
        }
        logger.log(Level.MONIT, "", flowLogData);
    }

    public static final void addMonitFailureTrace(Logger logger, FlowAttributes flowAttributes, String failureMessage, MessageExchange.Role role) {
        failureMessage = failureMessage.replace("\n", ERROR_MESSAGE_LINE_SEPARATOR);
        String flowInstanceId = null;
        String flowStepId = null;
        if (flowAttributes != null) {
            flowInstanceId = flowAttributes.getFlowInstanceId();
            flowStepId = flowAttributes.getFlowStepId();
        }
        Object flowLogData = role == MessageExchange.Role.CONSUMER ? new ConsumeFlowStepFailureLogData(flowInstanceId, flowStepId, failureMessage) : new ProvideFlowStepFailureLogData(flowInstanceId, flowStepId, failureMessage);
        logger.log(Level.MONIT, "", flowLogData);
    }
}

