/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.extensions.wsdl4complexwsdl.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.ow2.easywsdl.extensions.complexwsdl.ImportedDocuments;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl.ImportedDocumentsImpl;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl.inout.WSDL4ComplexWsdlReaderImpl;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfImport;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInclude;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImportedDocumentsFilter {
    private Map<URI, AbsItfDescription> descriptions = new HashMap<URI, AbsItfDescription>();
    private Map<URI, AbsItfSchema> schemas = new HashMap<URI, AbsItfSchema>();

    public ImportedDocumentsFilter(Document doc, WSDL4ComplexWsdlReaderImpl reader) throws WSDLException {
        NodeList elmts = doc.getDocumentElement().getElementsByTagNameNS("http://petals.ow2.org/wsdlExtensions", "importedDocuments");
        if (elmts != null && elmts.getLength() > 0) {
            Element importedDocuments = (Element)elmts.item(0);
            JAXBElement<ImportedDocuments> jAXBElement = reader.convertElement2ImportedDocuments(importedDocuments);
            ImportedDocumentsImpl imptDocs = new ImportedDocumentsImpl((ImportedDocuments)jAXBElement.getValue(), null);
            for (org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Document imptDoc : imptDocs.getDocuments()) {
                if (imptDoc.getImportedDescription() != null) {
                    this.descriptions.put(imptDoc.getLocation(), imptDoc.getImportedDescription());
                    continue;
                }
                if (imptDoc.getImportedSchema() == null) continue;
                this.schemas.put(imptDoc.getLocation(), (AbsItfSchema)imptDoc.getImportedSchema());
            }
        }
        for (AbsItfDescription absItfDescription : this.descriptions.values()) {
            ImportedDocumentsFilter.attachDescriptionInAllImportsAndIncludes(absItfDescription, this.descriptions, this.schemas);
        }
        for (AbsItfSchema absItfSchema : this.schemas.values()) {
            ImportedDocumentsFilter.attachSchemaInAllImportsAndIncludes(absItfSchema, this.schemas);
        }
    }

    public static void attachSchemaInAllImportsAndIncludes(AbsItfSchema s, Map<URI, AbsItfSchema> schemas) throws WSDLException {
        for (org.ow2.easywsdl.schema.api.absItf.AbsItfImport impt : s.getImports()) {
            impt.setSchema(schemas.get(impt.getLocationURI()));
        }
        for (org.ow2.easywsdl.schema.api.absItf.AbsItfInclude incl : s.getImports()) {
            incl.setSchema(schemas.get(incl.getLocationURI()));
        }
    }

    public static void attachDescriptionInAllImportsAndIncludes(AbsItfDescription d, Map<URI, AbsItfDescription> descriptions, Map<URI, AbsItfSchema> schemas) throws WSDLException {
        for (AbsItfImport impt : d.getImports()) {
            impt.setDescription(descriptions.get(impt.getLocationURI()));
        }
        for (AbsItfInclude incl : d.getIncludes()) {
            incl.setDescription(descriptions.get(incl.getLocationURI()));
        }
        if (d.getTypes() != null) {
            for (AbsItfSchema s : d.getTypes().getImportedSchemas()) {
                ImportedDocumentsFilter.attachSchemaInAllImportsAndIncludes(s, schemas);
            }
            for (AbsItfSchema s : d.getTypes().getSchemas()) {
                ImportedDocumentsFilter.attachSchemaInAllImportsAndIncludes(s, schemas);
            }
        }
    }

    public Map<URI, AbsItfDescription> getDescriptions() {
        return this.descriptions;
    }

    public Map<URI, AbsItfSchema> getSchemas() {
        return this.schemas;
    }
}

