package org.ow2.petals.bc.sql.steps

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;

import org.junit.After;
import org.junit.Test;
import static org.junit.Assert.*;

class InMemoryDerbySqlServerTest {

    @After
    public void afterTest(){
        InMemoryDerbySqlServer.stop();
    }

    @Test
    public void testStartServer(){
        InMemoryDerbySqlServer.start()
        assertTrue(DriverManager.getDriver(InMemoryDerbySqlServer.PROTOCOL)!=null)
    }

    @Test
    public void testStopserver(){
        InMemoryDerbySqlServer.start()
        InMemoryDerbySqlServer.stop()
        try{
            DriverManager.getDriver(InMemoryDerbySqlServer.PROTOCOL)
            fail()
        }catch (SQLException e) {
            // Its ok
        }
    }

    @Test
    public void testCreateDatabase(){
        InMemoryDerbySqlServer.start()
        InMemoryDerbySqlServer.createDatabase("foo")
        DriverManager.getConnection(InMemoryDerbySqlServer.PROTOCOL+"memory:foo")
    }

    @Test
    public void testDropDatabase(){
        InMemoryDerbySqlServer.start()
        InMemoryDerbySqlServer.createDatabase("foo")
        InMemoryDerbySqlServer.dropDatabase("foo")
        try{
            DriverManager.getConnection(InMemoryDerbySqlServer.PROTOCOL+"memory:foo")
            fail()
        }catch (SQLException e) {
            // Its ok
        }
    }

    @Test
    public void testCanRecreateDBAfterDrop(){
        InMemoryDerbySqlServer.start()
        InMemoryDerbySqlServer.createDatabase("foo")
        InMemoryDerbySqlServer.dropDatabase("foo")
        InMemoryDerbySqlServer.createDatabase("foo")
        DriverManager.getConnection(InMemoryDerbySqlServer.PROTOCOL+"memory:foo")
    }
}
