package org.ow2.petals.bc.sql.steps

import java.sql.Connection
import java.sql.Statement

import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named;
import org.ow2.petals.components.steps.AbstractComponentSteps

class AbstractSqlComponentSteps extends AbstractComponentSteps{

    @Given("a <database> created on a Derby sql server in memory mode")
    def startSqlServer(
        String database) {
        this.database = database;
        this.sqlServer.createDatabase(database);
    }

    @Given("a <table> composed of a string <column> and containing <value> on this database")
    def createTable(
        String table,
        String column,
        String value) {
        this.table = table;
        this.column = column;
        this.value = value;
        Connection connection = InMemoryDerbySqlServer.getAutoCommitConnectionToDatabase(this.database)
        try{
            Statement statement = connection.createStatement();
            statement.execute("CREATE TABLE ${table}("
                    + "${column} char(50))");
            statement.execute("INSERT INTO ${table} VALUES ('${value}')");
        }finally{
            connection.close();
        }
    }
}
