package org.ow2.petals.bc.sql.steps;

import static org.ow2.petals.components.stories.util.StoryContext.*

import org.jbehave.core.annotations.AfterScenario
import org.jbehave.core.annotations.AfterStories
import org.jbehave.core.annotations.BeforeStories
import org.jbehave.core.annotations.ScenarioType
import org.ow2.petals.components.steps.AbstractComponentSteps



class BeforeAndAfterSteps extends AbstractComponentSteps {

    
    @BeforeStories
    def startSqlServer() {
        this.sqlServer = new InMemoryDerbySqlServer();
        this.sqlServer.start();
    }
    
    @AfterScenario(uponType=ScenarioType.EXAMPLE)
    def removeDatabase(){
        this.sqlServer.dropDatabase(this.database);
    }

    @AfterStories
    def stopSqlServer(){
        this.sqlServer.stop();
    }
    
}

