package org.ow2.petals.bc.sql.steps;

import javax.jbi.messaging.FlowAttributes
import javax.xml.namespace.QName

import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named;
import org.jbehave.core.annotations.When
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation
import org.ow2.petals.bc.sql.Constants
import org.ow2.petals.component.api.Message
import org.ow2.petals.component.api.ServiceConfiguration

import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestMessage

class IdentifySqlProviderBeginStepSteps extends AbstractSqlComponentSteps {

    @Given("""a sql component <componentName> configured on <nodeName>
imports this external database as an internal service
<interfaceName>,<serviceName>,<endpointName>""")
    def importExternalFtpServerAsService(
        String componentName,
        String nodeName,
        String interfaceName,
        String serviceName,
        String endpointName) {
        this.component = createAndStartComponent(ComponentType.BC_SQL, createComponentConfiguration(componentName));
        ServiceConfiguration.ServiceType role = ServiceConfiguration.ServiceType.PROVIDE;
        this.provideServiceConfiguration = new ServiceConfiguration("identifySqlProvideStep",QName.valueOf(interfaceName),QName.valueOf(serviceName),endpointName, role);
        this.provideServiceConfiguration.setParameter("{" + Constants.NAMESPACE+"}" + Constants.DATABASE_URL, InMemoryDerbySqlServer.getConnectionUrl(this.database));
        this.component.installService(this.provideServiceConfiguration);
    }

    @When("""a request is received by this internal service with <operationName>,
the flow instance id <flowInstanceId> and the previous step id <previousStepId>""")
    def requestReceivedByServiceForOperation(
        String operationName,
        String flowInstanceId,
        String previousStepId) {
        Message message;
		String selectOperationName = "{${Constants.NAMESPACE}}select";
        if(operationName.equals(selectOperationName)) {
            String payload = "<sql xmlns='${Constants.NAMESPACE}'>SELECT ${this.column} FROM ${this.table} WHERE ${this.column}='${this.value}'</sql>";
            message = new WrappedRequestMessage(provideServiceConfiguration,  QName.valueOf(operationName),
                    AbsItfOperation.MEPPatternConstants.IN_OUT.value(),
                    createPayloadInputStream(payload), new FlowAttributes(flowInstanceId,
                    previousStepId));
        } else {
            String payload = "<sql xmlns='${Constants.NAMESPACE}'>delete from ${this.table} where ${this.column}='${this.value}'</sql>";
            message = new WrappedRequestMessage(provideServiceConfiguration,  QName.valueOf(operationName),
                    AbsItfOperation.MEPPatternConstants.IN_ONLY.value(),
                    createPayloadInputStream(payload), new FlowAttributes(flowInstanceId,
                    previousStepId));
        }
        this.component.pushMessage(message);
		// wait for the end of processing of the message
		this.component.pollResponseToClient();
    }
}

