package org.ow2.petals.bc.sql.steps

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;

class InMemoryDerbySqlServer {

    protected static String JDBC_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    protected static String PROTOCOL = "jdbc:derby:";

    private Connection conn;

    public static start(){
        Class.forName(JDBC_DRIVER).newInstance();
        println("Sql server started")
    }

    public static stop(){
        try{
            DriverManager.getConnection(InMemoryDerbySqlServer.PROTOCOL+";shutdown=true");
        }catch (SQLException e) {
            // do nothing its ok
            println("Sql server stopped")
        }
    }

    public static createDatabase(String database){
        DriverManager.getConnection(PROTOCOL + "memory:${database};create=true", new Properties());
        println("Database '${database}' created")
    }

    public static Connection dropDatabase(String database){
        try{
            DriverManager.getConnection(PROTOCOL + "memory:${database};drop=true", new Properties());
        }catch (SQLException e) {
            // do nothing its ok
            println("Database '${database}' dropped")
        }
    }

    public static Connection getAutoCommitConnectionToDatabase(String database){
        Connection connection = DriverManager.getConnection(PROTOCOL + "memory:${database}", new Properties());
        connection.setAutoCommit(true);
        return connection
    }

    public static String getConnectionUrl(String database){
        return PROTOCOL + "memory:${database}"
    }
}
