Story: identify sql provider begin step 

Scenario: thanks to MONIT log record

Given the ESB only composed of <nodeHost> known as <nodeName>
And MONIT enabled on <nodeName>

Given a <database> created on a Derby sql server in memory mode

Given a <table> composed of a string <column> and containing <value> on this database

Given a sql component <componentName> configured on <nodeName>
imports this external database as an internal service
<interfaceName>,<serviceName>,<endpointName>

When a request is received by this internal service with <operationName>,
the flow instance id <flowInstanceId> and the previous step id <previousStepId>

Then a MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:

| key                   | matcher | value
| traceCode             | equals  | provideFlowStepBegin                                         |                                                                           
| flowInstanceId        | equals  | flowInstanceId |                                                                                                                         
| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                           
| flowStepInterfaceName | equals  | interfaceName                                                |                                                                             
| flowStepServiceName   | equals  |  serviceName                                                |                                                                             
| flowStepEndpointName  | equals  |  endpointName                                               |                                                                             
| flowStepOperationName | equals  |  operationName                                              |                                                                             
| flowPreviousStepId    | equals  |  previousStepId |

Examples:
| nodeHost  | nodeName | database  | user  | password  | table     | column     |  value   | interfaceName                | serviceName                | endpointName  | operationName                                          | componentName | flowInstanceId                       | previousStepId |
| localhost | node1    | testMonit | user1 | password1 | testTable | testColumn | testData | {http://pns1/}interfaceName1 | {http://pns1/}serviceName1 | endpointName1 | {http://petals.ow2.org/components/sql/version-1}select | petals-bc-sql | ec7507e0-f01f-11e0-8411-0024e8b3e525 | ps7507e0-f01f-11e0-8411-0024e8b3e525 |
| localhost | node1    | testMonit | user1 | password1 | testTable | testColumn | testData | {http://pns1/}interfaceName1 | {http://pns1/}serviceName1 | endpointName1 | {http://petals.ow2.org/components/sql/version-1}delete | petals-bc-sql | ec7507e0-f01f-11e0-8411-0024e8b3e525 | ps7507e0-f01f-11e0-8411-0024e8b3e525 |
