/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.su;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.PrivateAccessor;
import org.ow2.petals.component.framework.util.WSDLUtilImpl;

public class AbstractServiceUnitManagerTest {
    Description description = null;

    @Before
    public void setUp() throws Exception {
        URL url = AbstractServiceUnitManagerTest.class.getResource("/ClockService.wsdl");
        if (url == null) {
            Assert.fail((String)"WSDL not found!");
        }
        try {
            this.description = WSDLUtilImpl.createWsdlDescription((URL)url, (boolean)false);
        }
        catch (WSDLException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAllMatch() throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Provides provides = new Provides();
        provides.setEndpointName("ClockEndpoint");
        provides.setServiceName(QName.valueOf("{http://petals.ow2.org}ClockService"));
        provides.setInterfaceName(QName.valueOf("{http://petals.ow2.org}Clock"));
        try {
            Method method = PrivateAccessor.getPrivateMethod(AbstractServiceUnitManager.class, "validateDescription");
            method.invoke((Object)new Object[]{Description.class, Provides.class}, this.description, provides);
        }
        catch (InvocationTargetException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBadInterface() throws IllegalArgumentException, IllegalAccessException {
        Provides provides = new Provides();
        provides.setEndpointName("ClockEndpoint");
        provides.setServiceName(QName.valueOf("{http://petals.ow2.org}ClockService"));
        provides.setInterfaceName(QName.valueOf("{http://petals.ow2.org}Clock2"));
        try {
            Method method = PrivateAccessor.getPrivateMethod(AbstractServiceUnitManager.class, "validateDescription");
            method.invoke((Object)new Object[]{Description.class, Provides.class}, this.description, provides);
            Assert.fail();
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    @Test
    public void testBadEndpoint() throws IllegalArgumentException, IllegalAccessException {
        Provides provides = new Provides();
        provides.setEndpointName("ClockEndpoint");
        provides.setServiceName(QName.valueOf("{http://petals.ow2.org}ClockService2"));
        provides.setInterfaceName(QName.valueOf("{http://petals.ow2.org}Clock"));
        try {
            Method method = PrivateAccessor.getPrivateMethod(AbstractServiceUnitManager.class, "validateDescription");
            method.invoke((Object)new Object[]{Description.class, Provides.class}, this.description, provides);
            Assert.fail();
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    @Test
    public void testBadService() throws IllegalArgumentException, IllegalAccessException {
        Provides provides = new Provides();
        provides.setEndpointName("ClockEndpoint2");
        provides.setServiceName(QName.valueOf("{http://petals.ow2.org}ClockService"));
        provides.setInterfaceName(QName.valueOf("{http://petals.ow2.org}Clock"));
        try {
            Method method = PrivateAccessor.getPrivateMethod(AbstractServiceUnitManager.class, "validateDescription");
            method.invoke((Object)new Object[]{Description.class, Provides.class}, this.description, provides);
            Assert.fail();
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

