/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.su;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import junit.framework.Assert;

public class PrivateAccessor {
    public static Object getPrivateField(Object o, String fieldName) {
        Assert.assertNotNull((Object)o);
        Assert.assertNotNull((Object)fieldName);
        Field[] fields = o.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            try {
                fields[i].setAccessible(true);
                return fields[i].get(o);
            }
            catch (IllegalAccessException ex) {
                Assert.fail((String)("IllegalAccessException accessing " + fieldName));
            }
        }
        Assert.fail((String)("Field '" + fieldName + "' not found"));
        return null;
    }

    public static void setPrivateField(Object o, String fieldName, Object value) throws IllegalArgumentException {
        Assert.assertNotNull((Object)o);
        Assert.assertNotNull((Object)fieldName);
        Assert.assertNotNull((Object)value);
        boolean set = false;
        Field[] fields = o.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length && !set; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            set = true;
            try {
                fields[i].setAccessible(true);
                fields[i].set(o, value);
                continue;
            }
            catch (IllegalAccessException ex) {
                Assert.fail((String)("IllegalAccessException accessing " + fieldName));
            }
        }
        if (!set) {
            throw new IllegalArgumentException("Field doesn't exist: " + fieldName);
        }
    }

    public static Method getPrivateMethod(Object o, String methodName) throws IllegalArgumentException {
        Method method = null;
        Assert.assertNotNull((Object)o);
        Assert.assertNotNull((Object)methodName);
        boolean set = false;
        Method[] methods = o.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length && !set; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            set = true;
            method = methods[i];
            method.setAccessible(true);
        }
        if (!set) {
            throw new IllegalArgumentException("Method doesn't exist: " + methodName);
        }
        return method;
    }

    public static Method getPrivateMethod(Class<?> clazz, String methodName, Class<?>[] listClazz) throws IllegalArgumentException, SecurityException, NoSuchMethodException {
        Assert.assertNotNull(clazz);
        Assert.assertNotNull((Object)methodName);
        Assert.assertNotNull(listClazz);
        Method method = clazz.getDeclaredMethod(methodName, listClazz);
        method.setAccessible(true);
        return method;
    }

    public static Method getPrivateMethod(Class<?> clazz, String methodName) throws IllegalArgumentException {
        Method method = null;
        Assert.assertNotNull(clazz);
        Assert.assertNotNull((Object)methodName);
        boolean set = false;
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length && !set; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            set = true;
            method = methods[i];
            method.setAccessible(true);
        }
        if (!set) {
            throw new IllegalArgumentException("Method doesn't exist: " + methodName);
        }
        return method;
    }
}

