/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.component.framework.util.FileNamePatternUtil;

public class FileNamePatternUtilTest {
    @Test
    public void testRegexToWildchar() {
        Assert.assertEquals((Object)"?.XXX?", (Object)FileNamePatternUtil.getInstance().regexToWildchar(".\\.XXX."));
    }

    @Test
    public void testWildcharToRegex() {
        Assert.assertEquals((Object)".*\\..*", (Object)FileNamePatternUtil.getInstance().wildcharToRegex("*.*"));
        Assert.assertEquals((Object)".\\.XXX.", (Object)FileNamePatternUtil.getInstance().wildcharToRegex("?.XXX?"));
    }

    @Test
    public void testBuildFileNameFilterFromRegex() {
        FileNamePatternUtil.RegexFileNameFilter a = FileNamePatternUtil.getInstance().buildFileNameFilterFromRegex(".*\\.a");
        Assert.assertTrue((boolean)a.accept(null, "XXX.a"));
        Assert.assertTrue((boolean)a.accept(null, ".a"));
        Assert.assertFalse((boolean)a.accept(null, "a"));
        Assert.assertFalse((boolean)a.accept(null, "XXX.aX"));
    }

    @Test
    public void testBuildFileNameFilterFromWildChar() {
        FileNamePatternUtil.RegexFileNameFilter a = FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar("*.a");
        Assert.assertTrue((boolean)a.accept(null, "XXX.a"));
        Assert.assertTrue((boolean)a.accept(null, ".a"));
        Assert.assertFalse((boolean)a.accept(null, "a"));
        Assert.assertFalse((boolean)a.accept(null, "XXX.aX"));
        a = FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar("X?X.X?X");
        Assert.assertTrue((boolean)a.accept(null, "XXX.XXX"));
        Assert.assertTrue((boolean)a.accept(null, "XzX.XzX"));
        Assert.assertFalse((boolean)a.accept(null, "ZZZ.ZZZ"));
        a = FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar("*.*");
        Assert.assertTrue((boolean)a.accept(null, "X.X"));
        Assert.assertFalse((boolean)a.accept(null, "XXX"));
    }

    @Test
    public void testBuildFileNameFilterFromFilters() {
        FileNamePatternUtil.RegexFileNameFilter a = FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar("*.a");
        FileNamePatternUtil.RegexFileNameFilter b = FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar("*.b");
        LinkedList<FileNamePatternUtil.RegexFileNameFilter> ab = new LinkedList<FileNamePatternUtil.RegexFileNameFilter>();
        ab.add(a);
        ab.add(b);
        FileNamePatternUtil.RegexFileNameFilter abf = FileNamePatternUtil.getInstance().buildFileNameFilterFromFilters(ab);
        Assert.assertTrue((boolean)abf.accept(null, "adri.a"));
        Assert.assertTrue((boolean)abf.accept(null, "adri.b"));
        Assert.assertFalse((boolean)abf.accept(null, "adri.c"));
    }
}

