/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.component.framework.util.MtomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class MtomUtilTest {
    static final String expectedXopIncludeMessage = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><xop:Include href=\"cid:contentId\" xmlns:xop=\"http://www.w3.org/2004/08/xop/include\"/>";
    static final String expectedSimpleMtomStructure1 = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><file xmlns=\"http://petals.ow2.org\"><xop:Include href=\"cid:contentID1\" xmlns:xop=\"http://www.w3.org/2004/08/xop/include\"/></file>";
    static final String expectedSimpleMtomStructure2 = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><rootNode><file xmlns=\"http://petals.ow2.org\"><xop:Include href=\"cid:contentID1\" xmlns:xop=\"http://www.w3.org/2004/08/xop/include\"/></file><file xmlns=\"http://petals.ow2.org\"><xop:Include href=\"cid:contentID2\" xmlns:xop=\"http://www.w3.org/2004/08/xop/include\"/></file></rootNode>";
    static final String expectedCustomMtomStructure1 = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><attachments xmlns=\"http://petals.ow2.org\"><customElement xmlns=\"http://custom.ns\"><xop:Include href=\"cid:contentID1\" xmlns:xop=\"http://www.w3.org/2004/08/xop/include\"/></customElement></attachments>";
    static final String expectedCustomMtomStructure2 = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><attachments xmlns=\"http://petals.ow2.org\"><customElement xmlns=\"http://custom.ns\"><xop:Include href=\"cid:contentID1\" xmlns:xop=\"http://www.w3.org/2004/08/xop/include\"/></customElement><customElement xmlns=\"http://custom.ns\"><xop:Include href=\"cid:contentID2\" xmlns:xop=\"http://www.w3.org/2004/08/xop/include\"/></customElement></attachments>";
    Document document;
    static final DocumentBuilder builder;

    @Before
    public void setUp() throws Exception {
        this.document = builder.newDocument();
    }

    @After
    public void tearDown() throws Exception {
        this.document = null;
    }

    @Test
    public void testGenerateSimpleMtomStructure1() throws TransformerException {
        DocumentFragment attchElt1 = MtomUtil.generateMtomStructure((Document)this.document, Arrays.asList("contentID1"), (QName)new QName("http://petals.ow2.org", "file"));
        Assert.assertNotNull((Object)attchElt1);
        this.document.appendChild(attchElt1);
        Assert.assertTrue((String)"Check expected simple mtom structure 1", (boolean)XMLComparator.isEquivalent((String)expectedSimpleMtomStructure1, (String)XMLPrettyPrinter.prettyPrint((Document)this.document)));
    }

    @Test
    public void testGenerateSimpleMtomStructure2() {
        DocumentFragment attchElt1 = MtomUtil.generateMtomStructure((Document)this.document, Arrays.asList("contentID1", "contentID2"), (QName)new QName("http://petals.ow2.org", "file"));
        Assert.assertNotNull((Object)attchElt1);
        Node rootNode = this.document.appendChild(this.document.createElement("rootNode"));
        rootNode.appendChild(attchElt1);
        Assert.assertTrue((String)"Check expected simple mtom structure 2", (boolean)XMLComparator.isEquivalent((String)expectedSimpleMtomStructure2, (String)XMLPrettyPrinter.prettyPrint((Document)this.document)));
    }

    @Test
    public void testGenerateComplexMtomStructure1() throws TransformerException {
        Node attchElt1 = MtomUtil.generateMtomStructure((Document)this.document, Arrays.asList("contentID1"), (QName)new QName("http://petals.ow2.org", "attachments"), (QName)new QName("http://custom.ns", "customElement"));
        Assert.assertNotNull((Object)attchElt1);
        this.document.appendChild(attchElt1);
        Assert.assertTrue((String)"Check Expected custom mtom structure 1", (boolean)XMLComparator.isEquivalent((String)expectedCustomMtomStructure1, (String)XMLPrettyPrinter.prettyPrint((Document)this.document)));
    }

    @Test
    public void testGenerateComplexMtomStructure2() throws TransformerException {
        Node attchElt1 = MtomUtil.generateMtomStructure((Document)this.document, Arrays.asList("contentID1", "contentID2"), (QName)new QName("http://petals.ow2.org", "attachments"), (QName)new QName("http://custom.ns", "customElement"));
        Assert.assertNotNull((Object)attchElt1);
        this.document.appendChild(attchElt1);
        Assert.assertTrue((String)"Check expected custom mtom structure 2", (boolean)XMLComparator.isEquivalent((String)expectedCustomMtomStructure2, (String)XMLPrettyPrinter.prettyPrint((Document)this.document)));
    }

    @Test
    public void testGenerateMtomXopElement() throws TransformerException {
        Node includeNode = MtomUtil.generateMtomXopElement((Document)this.document, (String)"contentId");
        Assert.assertNotNull((Object)includeNode);
        this.document.appendChild(includeNode);
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expectedXopIncludeMessage, (String)XMLPrettyPrinter.prettyPrint((Document)this.document)));
    }

    static {
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

