/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.component.framework.api.exception.FaultException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.exception.SOAP11FaultClientException;
import org.ow2.petals.component.framework.api.exception.SOAP11FaultServerException;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SourceUtilTest {
    @Test
    public void testcreateSoapFault_001() {
        try {
            SourceUtil sourceUtilImpl = new SourceUtil();
            SOAP11FaultServerException e = new SOAP11FaultServerException("My error", new URI("http://myActor"));
            Document soapFaultDocument = SourceUtil.createSoapFaultDocument((Throwable)e, (QName)new QName(""));
            this.compareSOAPFault(soapFaultDocument, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"), "My error", new URI("http://myActor"));
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testcreateSoapFault_002() {
        try {
            SourceUtil sourceUtilImpl = new SourceUtil();
            SOAP11FaultClientException e = new SOAP11FaultClientException("My error", new URI("http://myActor"));
            Document soapFaultDocument = SourceUtil.createSoapFaultDocument((Throwable)e, (QName)new QName(""));
            this.compareSOAPFault(soapFaultDocument, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client"), "My error", new URI("http://myActor"));
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testcreateSoapFault_003() {
        try {
            String faultString = "My error containg special characters [><&]";
            SourceUtil sourceUtilImpl = new SourceUtil();
            SOAP11FaultClientException e = new SOAP11FaultClientException("My error containg special characters [><&]", new URI("http://myActor"));
            Document soapFaultDocument = SourceUtil.createSoapFaultDocument((Throwable)e, (QName)new QName(""));
            this.compareSOAPFault(soapFaultDocument, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client"), "My error containg special characters [><&]", new URI("http://myActor"));
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testcreateSoapFault_004() {
        try {
            SourceUtil sourceUtilImpl = new SourceUtil();
            MyCustomFaultException e = new MyCustomFaultException("My error", new URI("http://myActor"));
            Document soapFaultDocument = SourceUtil.createSoapFaultDocument((Throwable)((Object)e), (QName)new QName(""));
            this.compareSOAPFault(soapFaultDocument, new QName("http://my-namespace.com", "my-local-part"), "My error", new URI("http://myActor"));
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void compareSOAPFault(Document document, QName expectedFaultCode, String expectedFaultString, URI expectedFaultActor) {
        Assert.assertNotNull((Object)document);
        Element faultElement = document.getDocumentElement();
        Assert.assertNotNull((Object)faultElement);
        Assert.assertEquals((Object)"Fault", (Object)faultElement.getLocalName());
        Assert.assertEquals((Object)"http://schemas.xmlsoap.org/soap/envelope/", (Object)faultElement.getNamespaceURI());
        Node faultCodeNode = faultElement.getFirstChild();
        Assert.assertNotNull((Object)faultCodeNode);
        Assert.assertEquals((Object)"faultcode", (Object)faultCodeNode.getNodeName());
        Assert.assertNull((Object)faultCodeNode.getNamespaceURI());
        Node faultCodeValueNode = faultCodeNode.getFirstChild();
        Assert.assertNotNull((Object)faultCodeValueNode);
        String faultCodeValuePrefix = faultCodeValueNode.lookupPrefix(expectedFaultCode.getNamespaceURI());
        Assert.assertEquals((Object)(faultCodeValuePrefix + ":" + expectedFaultCode.getLocalPart()), (Object)faultCodeValueNode.getNodeValue());
        Node faultStringNode = faultCodeNode.getNextSibling();
        Assert.assertNotNull((Object)faultStringNode);
        Assert.assertEquals((Object)"faultstring", (Object)faultStringNode.getNodeName());
        Assert.assertNull((Object)faultStringNode.getNamespaceURI());
        Node faultStringValueNode = faultStringNode.getFirstChild();
        Assert.assertNotNull((Object)faultStringValueNode);
        Assert.assertEquals((Object)expectedFaultString, (Object)faultStringValueNode.getNodeValue());
        Node faultActorNode = faultStringNode.getNextSibling();
        Assert.assertNotNull((Object)faultActorNode);
        Assert.assertEquals((Object)"faultactor", (Object)faultActorNode.getNodeName());
        Assert.assertNull((Object)faultActorNode.getNamespaceURI());
        Node faultActorValueNode = faultActorNode.getFirstChild();
        Assert.assertNotNull((Object)faultActorValueNode);
        Assert.assertEquals((Object)expectedFaultActor.toString(), (Object)faultActorValueNode.getNodeValue());
    }

    @Test
    public void testCreateDocument() {
        try {
            SourceUtil sourceUtilImpl = new SourceUtil();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = doc.createElement("test");
            element.setTextContent("coucou");
            doc.appendChild(element);
            Document finalDocument = SourceUtil.createDocument((Source)new DOMSource(doc));
            Assert.assertNotNull((Object)finalDocument);
            Assert.assertEquals((Object)"coucou", (Object)finalDocument.getDocumentElement().getTextContent());
        }
        catch (ParserConfigurationException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateDocumen2() {
        try {
            SourceUtil sourceUtilImpl = new SourceUtil();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = doc.createElement("test");
            element.setTextContent("coucou");
            doc.appendChild(element);
            Document finalDocument = SourceUtil.createDocument((Source)new DOMSource(doc), (boolean)false);
            Assert.assertNotNull((Object)finalDocument);
            Assert.assertEquals((Object)doc, (Object)finalDocument);
        }
        catch (ParserConfigurationException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateSourceString() {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><result xmlns=\"http://petals.ow2.org/petals-se-eip/scatter-gather\"><EnvoiESB xmlns=\"http://finances.gouv.fr/dgme/esb/webapp/webservice/wsdl/envoiesb\" xmlns:env=\"http://finances.gouv.fr/dgme/esb/webapp/webservice/wsdl/envoiesb\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">    <informationsGF xmlns=\"\">        <idEnveloppe>125</idEnveloppe>        <numeroDossier>GFDG</numeroDossier>        <destinataire>principal</destinataire>        <idEmetteur>GF</idEmetteur>    </informationsGF>    <informationsSI xmlns=\"\">        <idDestinataire>11111111111125</idDestinataire>        <idService>3</idService>        <idGuichet>1</idGuichet>    </informationsSI>    <mail xmlns=\"\">        <expediteur>component-test@devmail.com</expediteur>        <destinataire>component-test@devmail.com</destinataire>        <sujet>sujet</sujet>        <corps>corps</corps>    </mail>    <listeFichiers xmlns=\"\">        <fichier>                <nom>38001-A-8-4E0SNRYB-ent-0.xml</nom>        </fichier>        <fichier>                <nom>38002-A-8-4E0SNRYB-ent-0.xml</nom>        </fichier>        <fichier>                <nom>38003-A-8-4E0SNRYB-ent-0.xml</nom>        </fichier>    </listeFichiers></EnvoiESB></result>";
        try {
            Source source = SourceUtil.createSource((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><result xmlns=\"http://petals.ow2.org/petals-se-eip/scatter-gather\"><EnvoiESB xmlns=\"http://finances.gouv.fr/dgme/esb/webapp/webservice/wsdl/envoiesb\" xmlns:env=\"http://finances.gouv.fr/dgme/esb/webapp/webservice/wsdl/envoiesb\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">    <informationsGF xmlns=\"\">        <idEnveloppe>125</idEnveloppe>        <numeroDossier>GFDG</numeroDossier>        <destinataire>principal</destinataire>        <idEmetteur>GF</idEmetteur>    </informationsGF>    <informationsSI xmlns=\"\">        <idDestinataire>11111111111125</idDestinataire>        <idService>3</idService>        <idGuichet>1</idGuichet>    </informationsSI>    <mail xmlns=\"\">        <expediteur>component-test@devmail.com</expediteur>        <destinataire>component-test@devmail.com</destinataire>        <sujet>sujet</sujet>        <corps>corps</corps>    </mail>    <listeFichiers xmlns=\"\">        <fichier>                <nom>38001-A-8-4E0SNRYB-ent-0.xml</nom>        </fichier>        <fichier>                <nom>38002-A-8-4E0SNRYB-ent-0.xml</nom>        </fichier>        <fichier>                <nom>38003-A-8-4E0SNRYB-ent-0.xml</nom>        </fichier>    </listeFichiers></EnvoiESB></result>");
            Assert.assertNotNull((Object)source);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("unable to create the source: " + e.getMessage()));
        }
    }

    @Test
    public void testCreateDocumentSource() {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><result xmlns=\"http://petals.ow2.org/petals-se-eip/scatter-gather\"><EnvoiESB xmlns=\"http://finances.gouv.fr/dgme/esb/webapp/webservice/wsdl/envoiesb\" xmlns:env=\"http://finances.gouv.fr/dgme/esb/webapp/webservice/wsdl/envoiesb\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">    <informationsGF xmlns=\"\">        <idEnveloppe>125</idEnveloppe>        <numeroDossier>GFDG</numeroDossier>        <destinataire>principal</destinataire>        <idEmetteur>GF</idEmetteur>    </informationsGF>    <informationsSI xmlns=\"\">        <idDestinataire>11111111111125</idDestinataire>        <idService>3</idService>        <idGuichet>1</idGuichet>    </informationsSI>    <mail xmlns=\"\">        <expediteur>component-test@devmail.com</expediteur>        <destinataire>component-test@devmail.com</destinataire>        <sujet>sujet</sujet>        <corps>corps</corps>    </mail>    <listeFichiers xmlns=\"\">        <fichier>                <nom>38001-A-8-4E0SNRYB-ent-0.xml</nom>        </fichier>        <fichier>                <nom>38002-A-8-4E0SNRYB-ent-0.xml</nom>        </fichier>        <fichier>                <nom>38003-A-8-4E0SNRYB-ent-0.xml</nom>        </fichier>    </listeFichiers></EnvoiESB></result>";
        try {
            Source source = SourceUtil.createSource((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><result xmlns=\"http://petals.ow2.org/petals-se-eip/scatter-gather\"><EnvoiESB xmlns=\"http://finances.gouv.fr/dgme/esb/webapp/webservice/wsdl/envoiesb\" xmlns:env=\"http://finances.gouv.fr/dgme/esb/webapp/webservice/wsdl/envoiesb\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">    <informationsGF xmlns=\"\">        <idEnveloppe>125</idEnveloppe>        <numeroDossier>GFDG</numeroDossier>        <destinataire>principal</destinataire>        <idEmetteur>GF</idEmetteur>    </informationsGF>    <informationsSI xmlns=\"\">        <idDestinataire>11111111111125</idDestinataire>        <idService>3</idService>        <idGuichet>1</idGuichet>    </informationsSI>    <mail xmlns=\"\">        <expediteur>component-test@devmail.com</expediteur>        <destinataire>component-test@devmail.com</destinataire>        <sujet>sujet</sujet>        <corps>corps</corps>    </mail>    <listeFichiers xmlns=\"\">        <fichier>                <nom>38001-A-8-4E0SNRYB-ent-0.xml</nom>        </fichier>        <fichier>                <nom>38002-A-8-4E0SNRYB-ent-0.xml</nom>        </fichier>        <fichier>                <nom>38003-A-8-4E0SNRYB-ent-0.xml</nom>        </fichier>    </listeFichiers></EnvoiESB></result>");
            Document document = SourceUtil.createDocument((Source)source);
            Assert.assertNotNull((Object)document);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("unable to create the source: " + e.getMessage()));
        }
    }

    private static class MyCustomFaultException
    extends FaultException {
        private static final long serialVersionUID = 5724917270299632484L;

        public MyCustomFaultException(String faultString, URI faultActor) {
            super(new QName("http://my-namespace.com", "my-local-part"), faultString, faultActor);
        }
    }
}

