/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.jbidescriptor;

import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JBIDescriptorBuilderTest {
    @Test
    public void testComponentDescValidating() throws Exception {
        URL xmlURL = this.getClass().getResource("/component.xml");
        try {
            JBIDescriptorBuilder.validateJBIDescriptor((InputStream)xmlURL.openStream());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testComponentDescJavaBuilding() throws Exception {
        URL xmlURL = this.getClass().getResource("/component.xml");
        try {
            JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)xmlURL.openStream());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testComponentDescXMLBuilding() throws Exception {
        URL xmlURL = this.getClass().getResource("/component.xml");
        try {
            Jbi jbi = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)xmlURL.openStream());
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            JBIDescriptorBuilder.buildXmlJBIdescriptor((Jbi)jbi, (Node)document);
            Assert.assertEquals((Object)document.getFirstChild().getFirstChild().getLocalName(), (Object)"component");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSUProvideDescValidating() throws Exception {
        URL xmlURL = this.getClass().getResource("/su-provide.xml");
        try {
            JBIDescriptorBuilder.validateJBIDescriptor((InputStream)xmlURL.openStream());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testSUProvideDescJavaBuilding() throws Exception {
        URL xmlURL = this.getClass().getResource("/su-provide.xml");
        try {
            JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)xmlURL.openStream());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSUProvideDescXmlBuilding() throws Exception {
        URL xmlURL = this.getClass().getResource("/su-provide.xml");
        try {
            Jbi jbi = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)xmlURL.openStream());
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            JBIDescriptorBuilder.buildXmlJBIdescriptor((Jbi)jbi, (Node)document);
            Assert.assertEquals((Object)document.getFirstChild().getFirstChild().getFirstChild().getLocalName(), (Object)"provides");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSUConsumeDescValidating() throws Exception {
        URL xmlURL = this.getClass().getResource("/su-consume.xml");
        try {
            JBIDescriptorBuilder.validateJBIDescriptor((InputStream)xmlURL.openStream());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSUConsumeDescJavaBuilding() throws Exception {
        URL xmlURL = this.getClass().getResource("/su-consume.xml");
        try {
            JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)xmlURL.openStream());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSUConsumeDescXmlBuilding() throws Exception {
        URL xmlURL = this.getClass().getResource("/su-consume.xml");
        try {
            Jbi jbi = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)xmlURL.openStream());
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            JBIDescriptorBuilder.buildXmlJBIdescriptor((Jbi)jbi, (Node)document);
            Assert.assertEquals((Object)document.getFirstChild().getFirstChild().getFirstChild().getLocalName(), (Object)"consumes");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

