/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.dump;

import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.commons.dump.DumpFileGenerationOrchestrator;
import org.ow2.petals.commons.dump.DumpFileGenerator;

public class DumpFileGeneratorTest {
    private static final String TEST_PETALS_FILEHANDLER_BASEDIR = "/home/user/tools/petals/logs";
    private static final String TEST_FLOW_INSTANCE_ID = "myFlowInstanceId";
    private static final int POOL_SIZE = 100;
    private static final int ITERATIONS = 100;

    @BeforeClass
    public static void beforeClass() {
        PetalsExecutionContext.putPetalsFileHandlerBaseDir((String)TEST_PETALS_FILEHANDLER_BASEDIR);
        PetalsExecutionContext.putFlowInstanceId((String)TEST_FLOW_INSTANCE_ID);
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("petals.home");
        ExecutionContext.getProperties().clear();
    }

    @Test
    public void testGetUniqueDumpFileReturnNotNullFile() {
        File dumpFile = DumpFileGenerator.getUniqueDumpFile();
        TestCase.assertNotNull((Object)dumpFile);
        TestCase.assertNotNull((Object)dumpFile.getAbsolutePath());
    }

    @Test
    public void testGetUniqueDumpFileReturnExpectedFilePathPattern() {
        String datePart = "[0-9]{4}\\.[0-9]{2}\\.[0-9]{2}-[0-9]{2}:[0-9]{2}:[0-9]{2}:[0-9]{3}";
        String uuidPart = "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}";
        String expectedFilePathPattern = "^/home/user/tools/petals/logs" + File.separator + "" + "flow-monitoring" + File.separator + TEST_FLOW_INSTANCE_ID + File.separator + "dump" + File.separator + datePart + "_" + uuidPart + ".dump" + "$";
        File dumpFile = DumpFileGenerator.getUniqueDumpFile();
        TestCase.assertTrue((String)String.format("File path doesn't match expected pattern '%s': %s", expectedFilePathPattern, dumpFile.getAbsolutePath()), (boolean)dumpFile.getAbsolutePath().matches(expectedFilePathPattern));
    }

    @Test
    public void testGetUniqueDumpFileDontReturnDirectory() {
        File dumpFile = DumpFileGenerator.getUniqueDumpFile();
        Assert.assertFalse((String)"Returned file mustn't be a directory", (boolean)dumpFile.isDirectory());
    }

    @Test
    public void testGetUniqueDumpFileReturnFileNameStartingWithCurrentDate() throws ParseException {
        Date before = new Date();
        File dumpFile = DumpFileGenerator.getUniqueDumpFile();
        Date after = new Date();
        String generatedDate = this.extractDatePart(dumpFile.getName());
        Date dumpFileDate = DumpFileGenerator.dateFormat.parse(generatedDate);
        Assert.assertTrue((String)("File name date part must be current date : " + generatedDate + " after or equals to " + DumpFileGenerator.dateFormat.format(before) + " and before or equals to " + DumpFileGenerator.dateFormat.format(after)), (!(!dumpFileDate.after(before) && !dumpFileDate.equals(before) || !dumpFileDate.before(after) && !dumpFileDate.equals(after)) ? 1 : 0) != 0);
    }

    private String extractDatePart(String name) {
        return name.split("_")[0];
    }

    @Test
    public void testSuccessiveCallToGetUniqueDumpFileReturnOrderedFilePath() {
        File dumpFile1 = DumpFileGenerator.getUniqueDumpFile();
        File dumpFile2 = DumpFileGenerator.getUniqueDumpFile();
        Assert.assertTrue((String)"Successive call must return date ordered file path", (dumpFile1.getName().compareTo(dumpFile2.getName()) <= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetUniqueDumpFileGenerateUniqueFilePath() {
        try {
            System.gc();
            new DumpFileGenerationOrchestrator().orchestrate(100, 100);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

