/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.api;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.logger.LogData;
import com.ebmwebsourcing.easycommons.logger.TestHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketException;
import java.util.List;
import java.util.Map;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.commons.logger.TraceCode;
import org.ow2.petals.component.api.Component;
import org.ow2.petals.component.api.ComponentConfiguration;
import org.ow2.petals.component.api.Message;
import org.ow2.petals.component.api.ServiceConfiguration;

public abstract class AbstractComponentTest {
    protected Component componentUnderTest;
    protected ComponentConfiguration componentConfiguration;
    protected TestHandler testHandler;
    protected Logger logger;

    @Before
    public void before() {
        this.testHandler = new TestHandler();
        this.logger = TestHandler.getLoggerWithTestHandler((String)"testLogger", (TestHandler)this.testHandler);
        this.componentConfiguration = this.createComponentConfiguration(this.logger);
        this.componentUnderTest = this.createComponentUnderTest(this.componentConfiguration);
    }

    @After
    public void after() {
        if (this.componentUnderTest.isStarted()) {
            this.componentUnderTest.stop();
        }
    }

    protected final InputStream createPayloadInputStream(String payloadAsString) {
        return new ByteArrayInputStream(payloadAsString.getBytes());
    }

    protected ComponentConfiguration createComponentConfiguration(Logger logger) {
        return new ComponentConfiguration(logger);
    }

    protected abstract Component createComponentUnderTest(ComponentConfiguration var1);

    protected abstract Message createMessageToProcessAsProvider(ServiceConfiguration var1) throws Exception;

    @Test
    public void testIsStartedAfterConstruction() throws Exception {
        Assert.assertFalse((boolean)this.componentUnderTest.isStarted());
    }

    @Test
    public void testIsStartedAfterStart() throws Exception {
        this.componentUnderTest.start();
        Assert.assertTrue((boolean)this.componentUnderTest.isStarted());
    }

    @Test
    public void testIsStartedAfterStop() throws Exception {
        this.componentUnderTest.start();
        this.componentUnderTest.stop();
        Assert.assertFalse((boolean)this.componentUnderTest.isStarted());
    }

    @Test
    public void testInstallService() throws Exception {
        this.componentUnderTest.start();
        ServiceConfiguration serviceConfiguration = this.createTestProvideServiceConfiguration();
        Assert.assertFalse((boolean)this.componentUnderTest.isServiceInstalled(serviceConfiguration));
        this.componentUnderTest.installService(serviceConfiguration);
        Assert.assertTrue((boolean)this.componentUnderTest.isServiceInstalled(serviceConfiguration));
    }

    @Test
    public void testUnInstallService() throws Exception {
        this.componentUnderTest.start();
        ServiceConfiguration serviceConfiguration = this.createTestProvideServiceConfiguration();
        Assert.assertFalse((boolean)this.componentUnderTest.isServiceInstalled(serviceConfiguration));
        this.componentUnderTest.installService(serviceConfiguration);
        Assert.assertTrue((boolean)this.componentUnderTest.isServiceInstalled(serviceConfiguration));
        this.componentUnderTest.uninstallService(serviceConfiguration);
        Assert.assertFalse((boolean)this.componentUnderTest.isServiceInstalled(serviceConfiguration));
    }

    @Test
    public void testUnInstallAllServices() throws Exception {
        this.componentUnderTest.start();
        ServiceConfiguration serviceConfiguration = this.createTestProvideServiceConfiguration();
        Assert.assertFalse((boolean)this.componentUnderTest.isServiceInstalled(serviceConfiguration));
        this.componentUnderTest.installService(serviceConfiguration);
        Assert.assertTrue((boolean)this.componentUnderTest.isServiceInstalled(serviceConfiguration));
        this.componentUnderTest.uninstallAllServices();
        Assert.assertFalse((boolean)this.componentUnderTest.isServiceInstalled(serviceConfiguration));
    }

    @Test
    public void testNoMonitAfterStart() throws Exception {
        this.componentUnderTest.start();
        Assert.assertEquals((long)0L, (long)this.testHandler.getAllRecords(Level.MONIT).size());
    }

    protected abstract ServiceConfiguration createTestProvideServiceConfiguration() throws Exception;

    protected ServiceConfiguration createTestProvideServiceBaseConfiguration() throws Exception {
        ServiceConfiguration testInternalServiceConguration = new ServiceConfiguration("testProvideService", new QName("http://testProvideService", "testProvideInterfaceName"), new QName("http://testProvideService", "testServiceName"), "testEndpointName", ServiceConfiguration.ServiceType.PROVIDE);
        return testInternalServiceConguration;
    }

    @Test(timeout=300000L)
    public void testProcessMessageAsConsumerLogsNothingBecauseMonitDisabled() throws Exception {
        this.componentUnderTest.start();
        ServiceConfiguration consumeServiceConfiguration = this.createTestConsumeServiceConfiguration();
        this.componentUnderTest.installService(consumeServiceConfiguration);
        this.logger.setLevel(Level.INFO);
        this.generateExternalEvent();
        this.componentUnderTest.pollRequestToServer();
        List records = this.testHandler.getAllRecords(Level.MONIT);
        Assert.assertEquals((long)0L, (long)records.size());
    }

    protected abstract ServiceConfiguration createTestConsumeServiceConfiguration() throws Exception;

    protected abstract Map<String, String> generateExternalEvent() throws Exception;

    protected void checkLoggedMonitRecordsOnBeginningOfProcessMessageAsConsumer(List<LogRecord> logRecords, ServiceConfiguration serviceConfiguration, Map<String, String> expectedSpecificParams) throws SocketException {
        Assert.assertEquals((long)1L, (long)logRecords.size());
        LogRecord record = logRecords.get(0);
        Object[] logParameters = record.getParameters();
        Assert.assertEquals((long)1L, (long)logParameters.length);
        Assert.assertTrue((boolean)(logParameters[0] instanceof LogData));
        LogData logData = (LogData)logParameters[0];
        Assert.assertEquals((Object)TraceCode.CONSUME_FLOW_STEP_BEGIN, (Object)logData.get((Object)"traceCode"));
        Assert.assertFalse((boolean)StringHelper.isNullOrEmpty((String)((String)logData.get((Object)"flowInstanceId"))));
        Assert.assertFalse((boolean)StringHelper.isNullOrEmpty((String)((String)logData.get((Object)"flowStepId"))));
        Assert.assertEquals((Object)serviceConfiguration.getInterfaceQName().toString(), (Object)logData.get((Object)"flowInterfaceName"));
        Assert.assertEquals((Object)serviceConfiguration.getServiceQName().toString(), (Object)logData.get((Object)"flowServiceName"));
        Assert.assertEquals((Object)serviceConfiguration.getEndpointName(), (Object)logData.get((Object)"flowEndpointName"));
        for (String logDataKey : expectedSpecificParams.keySet()) {
            String expectedParamValue = expectedSpecificParams.get(logDataKey);
            Assert.assertEquals((Object)expectedParamValue, (Object)logData.get((Object)logDataKey));
        }
    }
}

