/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.components.stories.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.components.stories.util.LogInfoFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogInfoFinderTest
implements GroovyObject {
    private static final String logTemplate = "nodeName logTime logLevel [loggerName] : logData";
    private static final String NODE_NAME_SAMPLE = "node1";
    private static final String LOG_TIME_SAMPLE = "2011/08/25 15:44:44,532 GMT+0200";
    private static final String MONIT_LOG_LEVEL = "MONIT";
    private static final String LOGGER_NAME_SAMPLE = "Petals.Container.Components.petals-se-bpel";
    private static final String LOG_DATA_SAMPLE = "traceCode = 'provideFlowStepBegin',flowInstanceId = '62cdea40-cf20-11e0-bdfa-000c29523cc7',flowStepId = '64083f00-cf20-11e0-87fc-000c29523cc7',flowStepInterfaceName = '{http://usecase1/bpel-P12/}interfaceName1',flowStepServiceName = '{http://usecase1/bpel-P12/}serviceName1',flowStepOperationName = '{http://usecase1/bpel-P12/}process',flowStepEndpointName = 'endpointName1',flowPreviousStepId = '62ce3860-cf20-11e0-bdfa-000c29523cc7'";
    private static final String monitLogSample;
    private static final String otherLevelLogSample = "node1 2011/08/25 15:44:44,532 GMT+0200 INFO [Petals.Container.Components.petals-se-bpel] : BPEL-Processes deployment on Core server has been performed";
    private static final String problematicLogSample = "node1 2011/08/25 15:44:44,532 GMT+0200 INFO [Petals.Container.Components.petals-se-bpel] : node2 2012/08/25 16:44:44,532 GMT-0300 MONIT [Petals.Container.Components.petals-se-quartz]";
    private static final String emptyLog = "";
    private static final Map<String, String> emptyMap;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public LogInfoFinderTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void testIsMonitLogTraceForMonitLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[0].callStatic(Assert.class, callSiteArray[1].call(LogInfoFinder.class, (Object)monitLogSample));
    }

    @Test
    public void testIsMonitLogTraceForOtherLevelLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[2].callStatic(Assert.class, callSiteArray[3].call(LogInfoFinder.class, (Object)otherLevelLogSample));
    }

    @Test
    public void testIsMonitLogTraceForProblematicLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[4].callStatic(Assert.class, callSiteArray[5].call(LogInfoFinder.class, (Object)problematicLogSample));
    }

    @Test
    public void testIsMonitLogTraceForEmptyLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[6].callStatic(Assert.class, callSiteArray[7].call(LogInfoFinder.class, (Object)emptyLog));
    }

    @Test
    public void testIsMonitLogTraceForNullLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[8].callStatic(Assert.class, callSiteArray[9].call(LogInfoFinder.class, null));
    }

    @Test
    public void testIsValidLogTraceForMonitLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[10].callStatic(Assert.class, callSiteArray[11].call(LogInfoFinder.class, (Object)monitLogSample));
    }

    @Test
    public void testIsValidLogTraceForOtherLevelLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[12].callStatic(Assert.class, callSiteArray[13].call(LogInfoFinder.class, (Object)otherLevelLogSample));
    }

    @Test
    public void testIsValidLogTraceForProblematicLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[14].callStatic(Assert.class, callSiteArray[15].call(LogInfoFinder.class, (Object)problematicLogSample));
    }

    @Test
    public void testIsValidLogTraceForEmptyLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[16].callStatic(Assert.class, callSiteArray[17].call(LogInfoFinder.class, (Object)emptyLog));
    }

    @Test
    public void testIsValidLogTraceForNullLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[18].callStatic(Assert.class, callSiteArray[19].call(LogInfoFinder.class, null));
    }

    @Test
    public void testGetNodeNameFromMonitLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        Reference templateForLogNameTest = new Reference(callSiteArray[20].call(callSiteArray[21].call(callSiteArray[22].call(callSiteArray[23].call((Object)logTemplate, (Object)"logTime", (Object)LOG_TIME_SAMPLE), (Object)"logLevel", (Object)MONIT_LOG_LEVEL), (Object)"loggerName", (Object)LOGGER_NAME_SAMPLE), (Object)"logData", (Object)LOG_DATA_SAMPLE));
        List nodeNames = ScriptBytecodeAdapter.createList((Object[])new Object[]{NODE_NAME_SAMPLE, "2e3r5r4t", "111", "aaaaa", emptyLog});
        callSiteArray[24].call((Object)nodeNames, (Object)new GeneratedClosure(this, this, templateForLogNameTest){
            private /* synthetic */ Reference templateForLogNameTest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _testGetNodeNameFromMonitLog_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.templateForLogNameTest = reference = templateForLogNameTest;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testGetNodeNameFromMonitLog_closure1.$getCallSiteArray();
                Object parametrizedMonitLog = callSiteArray[0].call(this.templateForLogNameTest.get(), (Object)"nodeName", it);
                return callSiteArray[1].callCurrent((GroovyObject)this, parametrizedMonitLog, it);
            }

            public Object getTemplateForLogNameTest() {
                CallSite[] callSiteArray = _testGetNodeNameFromMonitLog_closure1.$getCallSiteArray();
                return this.templateForLogNameTest.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testGetNodeNameFromMonitLog_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testGetNodeNameFromMonitLog_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _testGetNodeNameFromMonitLog_closure1.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _testGetNodeNameFromMonitLog_closure1.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "replaceFirst";
                stringArray[1] = "testGetNodeName";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _testGetNodeNameFromMonitLog_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testGetNodeNameFromMonitLog_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testGetNodeNameFromMonitLog_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    @Test
    public void testGetNodeNameFromProblematicLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[25].callCurrent((GroovyObject)this, (Object)problematicLogSample, (Object)NODE_NAME_SAMPLE);
        } else {
            this.testGetNodeName(problematicLogSample, NODE_NAME_SAMPLE);
        }
    }

    private void testGetNodeName(String logString, String expectedNodeName) {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        String actualNodeName = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].call(LogInfoFinder.class, (Object)logString), String.class);
        callSiteArray[27].callStatic(Assert.class, (Object)"Bad node name", (Object)expectedNodeName, (Object)actualNodeName);
    }

    @Test
    public void testGetLogTimeFromMonitLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        Reference templateForLogTimeTest = new Reference(callSiteArray[28].call(callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call((Object)logTemplate, (Object)"nodeName", (Object)NODE_NAME_SAMPLE), (Object)"logLevel", (Object)MONIT_LOG_LEVEL), (Object)"loggerName", (Object)LOGGER_NAME_SAMPLE), (Object)"logData", (Object)LOG_DATA_SAMPLE));
        List logTimes = ScriptBytecodeAdapter.createList((Object[])new Object[]{LOG_TIME_SAMPLE, "2011/08/25 15:44:44,532 GMT-0200", "2011/08/25 15:44:44,532 GMT-0700", "2011/08/25 00:00:00,000 GMT+0200"});
        callSiteArray[32].call((Object)logTimes, (Object)new GeneratedClosure(this, this, templateForLogTimeTest){
            private /* synthetic */ Reference templateForLogTimeTest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _testGetLogTimeFromMonitLog_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.templateForLogTimeTest = reference = templateForLogTimeTest;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testGetLogTimeFromMonitLog_closure2.$getCallSiteArray();
                Object parametrizedMonitLog = callSiteArray[0].call(this.templateForLogTimeTest.get(), (Object)"logTime", it);
                return callSiteArray[1].callCurrent((GroovyObject)this, parametrizedMonitLog, it);
            }

            public Object getTemplateForLogTimeTest() {
                CallSite[] callSiteArray = _testGetLogTimeFromMonitLog_closure2.$getCallSiteArray();
                return this.templateForLogTimeTest.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testGetLogTimeFromMonitLog_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testGetLogTimeFromMonitLog_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _testGetLogTimeFromMonitLog_closure2.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _testGetLogTimeFromMonitLog_closure2.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "replaceFirst";
                stringArray[1] = "testGetLogTime";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _testGetLogTimeFromMonitLog_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testGetLogTimeFromMonitLog_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testGetLogTimeFromMonitLog_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    @Test
    public void testGetLogTimeFromProblematicLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[33].callCurrent((GroovyObject)this, (Object)problematicLogSample, (Object)LOG_TIME_SAMPLE);
        } else {
            this.testGetLogTime(problematicLogSample, LOG_TIME_SAMPLE);
        }
    }

    private void testGetLogTime(String logString, String expectedLogTime) {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        String actualLogTime = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call(LogInfoFinder.class, (Object)logString), String.class);
        callSiteArray[35].callStatic(Assert.class, (Object)"Bad log time", (Object)expectedLogTime, (Object)actualLogTime);
    }

    @Test
    public void testGetLogLevelFromMonitLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        Reference templateForLogLevelTest = new Reference(callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].call(callSiteArray[39].call((Object)logTemplate, (Object)"nodeName", (Object)NODE_NAME_SAMPLE), (Object)"logTime", (Object)LOG_TIME_SAMPLE), (Object)"loggerName", (Object)LOGGER_NAME_SAMPLE), (Object)"logData", (Object)LOG_DATA_SAMPLE));
        List logLevels = ScriptBytecodeAdapter.createList((Object[])new Object[]{MONIT_LOG_LEVEL, "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST", emptyLog});
        callSiteArray[40].call((Object)logLevels, (Object)new GeneratedClosure(this, this, templateForLogLevelTest){
            private /* synthetic */ Reference templateForLogLevelTest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _testGetLogLevelFromMonitLog_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.templateForLogLevelTest = reference = templateForLogLevelTest;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testGetLogLevelFromMonitLog_closure3.$getCallSiteArray();
                Object parametrizedMonitLog = callSiteArray[0].call(this.templateForLogLevelTest.get(), (Object)"logLevel", it);
                return callSiteArray[1].callCurrent((GroovyObject)this, parametrizedMonitLog, it);
            }

            public Object getTemplateForLogLevelTest() {
                CallSite[] callSiteArray = _testGetLogLevelFromMonitLog_closure3.$getCallSiteArray();
                return this.templateForLogLevelTest.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testGetLogLevelFromMonitLog_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testGetLogLevelFromMonitLog_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _testGetLogLevelFromMonitLog_closure3.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _testGetLogLevelFromMonitLog_closure3.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "replaceFirst";
                stringArray[1] = "testGetLogLevel";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _testGetLogLevelFromMonitLog_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testGetLogLevelFromMonitLog_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testGetLogLevelFromMonitLog_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    @Test
    public void testGetLogLevelFromProblematicLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[41].callCurrent((GroovyObject)this, (Object)problematicLogSample, (Object)"INFO");
        } else {
            this.testGetLogLevel(problematicLogSample, "INFO");
        }
    }

    private void testGetLogLevel(String logString, String expectedLogLevel) {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        String actualLogLevel = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].call(LogInfoFinder.class, (Object)logString), String.class);
        callSiteArray[43].callStatic(Assert.class, (Object)"Bad log level", (Object)expectedLogLevel, (Object)actualLogLevel);
    }

    @Test
    public void testGetLoggerNameFromMonitLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        Reference templateForLoggerNameTest = new Reference(callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].call(callSiteArray[47].call((Object)logTemplate, (Object)"nodeName", (Object)NODE_NAME_SAMPLE), (Object)"logTime", (Object)LOG_TIME_SAMPLE), (Object)"logLevel", (Object)MONIT_LOG_LEVEL), (Object)"logData", (Object)LOG_DATA_SAMPLE));
        List loggerNames = ScriptBytecodeAdapter.createList((Object[])new Object[]{LOGGER_NAME_SAMPLE, "Petals.Container.Components", emptyLog, "Petals"});
        callSiteArray[48].call((Object)loggerNames, (Object)new GeneratedClosure(this, this, templateForLoggerNameTest){
            private /* synthetic */ Reference templateForLoggerNameTest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _testGetLoggerNameFromMonitLog_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.templateForLoggerNameTest = reference = templateForLoggerNameTest;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testGetLoggerNameFromMonitLog_closure4.$getCallSiteArray();
                Object parametrizedMonitLog = callSiteArray[0].call(this.templateForLoggerNameTest.get(), (Object)"loggerName", it);
                return callSiteArray[1].callCurrent((GroovyObject)this, parametrizedMonitLog, it);
            }

            public Object getTemplateForLoggerNameTest() {
                CallSite[] callSiteArray = _testGetLoggerNameFromMonitLog_closure4.$getCallSiteArray();
                return this.templateForLoggerNameTest.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testGetLoggerNameFromMonitLog_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testGetLoggerNameFromMonitLog_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _testGetLoggerNameFromMonitLog_closure4.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _testGetLoggerNameFromMonitLog_closure4.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "replaceFirst";
                stringArray[1] = "testGetLoggerName";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _testGetLoggerNameFromMonitLog_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testGetLoggerNameFromMonitLog_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testGetLoggerNameFromMonitLog_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    @Test
    public void testGetLoggerNameFromProblematicLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[49].callCurrent((GroovyObject)this, (Object)problematicLogSample, (Object)LOGGER_NAME_SAMPLE);
        } else {
            this.testGetLoggerName(problematicLogSample, LOGGER_NAME_SAMPLE);
        }
    }

    private void testGetLoggerName(String logString, String expectedLoggerName) {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        String actualLoggerName = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].call(LogInfoFinder.class, (Object)logString), String.class);
        callSiteArray[51].callStatic(Assert.class, (Object)"Bad logger name", (Object)expectedLoggerName, (Object)actualLoggerName);
    }

    @Test
    public void testGetMonitLogDataFromMonitLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        Map expectedMonitLogData = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"traceCode", "provideFlowStepBegin", "flowInstanceId", "62cdea40-cf20-11e0-bdfa-000c29523cc7", "flowStepId", "64083f00-cf20-11e0-87fc-000c29523cc7", "flowStepInterfaceName", "{http://usecase1/bpel-P12/}interfaceName1", "flowStepServiceName", "{http://usecase1/bpel-P12/}serviceName1", "flowStepOperationName", "{http://usecase1/bpel-P12/}process", "flowStepEndpointName", "endpointName1", "flowPreviousStepId", "62ce3860-cf20-11e0-bdfa-000c29523cc7"});
        callSiteArray[52].callCurrent((GroovyObject)this, (Object)monitLogSample, (Object)expectedMonitLogData);
    }

    @Test
    public void testGetMonitLogDataReturnOrderedMap() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        Reference expectedMonitLogData = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"traceCode", "provideFlowStepBegin", "flowInstanceId", "62cdea40-cf20-11e0-bdfa-000c29523cc7", "flowStepId", "64083f00-cf20-11e0-87fc-000c29523cc7", "flowStepInterfaceName", "{http://usecase1/bpel-P12/}interfaceName1", "flowStepServiceName", "{http://usecase1/bpel-P12/}serviceName1", "flowStepOperationName", "{http://usecase1/bpel-P12/}process", "flowStepEndpointName", "endpointName1", "flowPreviousStepId", "62ce3860-cf20-11e0-bdfa-000c29523cc7"}), LinkedHashMap.class)));
        LinkedHashMap actualLogData = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].call(LogInfoFinder.class, (Object)monitLogSample), LinkedHashMap.class);
        callSiteArray[54].call(callSiteArray[55].call((Object)actualLogData), (Object)new GeneratedClosure(this, this, expectedMonitLogData){
            private /* synthetic */ Reference expectedMonitLogData;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _testGetMonitLogDataReturnOrderedMap_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.expectedMonitLogData = reference = expectedMonitLogData;
            }

            public Object doCall(Object obj, Object i) {
                CallSite[] callSiteArray = _testGetMonitLogDataReturnOrderedMap_closure5.$getCallSiteArray();
                return callSiteArray[0].callStatic(Assert.class, callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(this.expectedMonitLogData.get()), i), obj));
            }

            public Object call(Object obj, Object i) {
                CallSite[] callSiteArray = _testGetMonitLogDataReturnOrderedMap_closure5.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, obj, i);
            }

            public LinkedHashMap getExpectedMonitLogData() {
                CallSite[] callSiteArray = _testGetMonitLogDataReturnOrderedMap_closure5.$getCallSiteArray();
                return (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)this.expectedMonitLogData.get(), LinkedHashMap.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testGetMonitLogDataReturnOrderedMap_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _testGetMonitLogDataReturnOrderedMap_closure5.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _testGetMonitLogDataReturnOrderedMap_closure5.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "assertTrue";
                stringArray[1] = "equals";
                stringArray[2] = "getAt";
                stringArray[3] = "newKeyIterator";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _testGetMonitLogDataReturnOrderedMap_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testGetMonitLogDataReturnOrderedMap_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testGetMonitLogDataReturnOrderedMap_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    @Test
    public void testGetMonitLogDataFromOtherLevelLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[56].callCurrent((GroovyObject)this, (Object)otherLevelLogSample, emptyMap);
    }

    @Test
    public void testGetMonitLogDataFromEmptyLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[57].callCurrent((GroovyObject)this, (Object)emptyLog, emptyMap);
    }

    @Test
    public void testGetMonitLogDataFromNullLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        callSiteArray[58].callCurrent((GroovyObject)this, null, emptyMap);
    }

    private void testGetMonitLogData(String logString, Map<String, String> expectedMonitLogData) {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        Map actualMonitLogData = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].call(LogInfoFinder.class, (Object)logString), Map.class);
        callSiteArray[60].callStatic(Assert.class, expectedMonitLogData, (Object)actualMonitLogData);
    }

    @Test
    public void testGetLogDataFromMonitLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[61].callCurrent((GroovyObject)this, (Object)monitLogSample, (Object)LOG_DATA_SAMPLE);
        } else {
            this.testGetLogData(monitLogSample, LOG_DATA_SAMPLE);
        }
    }

    @Test
    public void testGetLogDataFromOtherLevelLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[62].callCurrent((GroovyObject)this, (Object)otherLevelLogSample, (Object)"BPEL-Processes deployment on Core server has been performed");
        } else {
            this.testGetLogData(otherLevelLogSample, "BPEL-Processes deployment on Core server has been performed");
        }
    }

    @Test
    public void testGetLogDataFromProblematicLog() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[63].callCurrent((GroovyObject)this, (Object)problematicLogSample, (Object)"node2 2012/08/25 16:44:44,532 GMT-0300 MONIT [Petals.Container.Components.petals-se-quartz]");
        } else {
            this.testGetLogData(problematicLogSample, "node2 2012/08/25 16:44:44,532 GMT-0300 MONIT [Petals.Container.Components.petals-se-quartz]");
        }
    }

    private void testGetLogData(String logString, String expectedLogData) {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        String actualLogData = (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].call(LogInfoFinder.class, (Object)logString), String.class);
        callSiteArray[65].callStatic(Assert.class, (Object)"Bad log data", (Object)expectedLogData, (Object)actualLogData);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(LogInfoFinderTest.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{emptyLog, emptyLog}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, LogInfoFinderTest.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{emptyLog, emptyLog}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectField(LogInfoFinderTest.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{emptyLog, emptyLog}), String.class)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LogInfoFinderTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        CallSite[] callSiteArray = LogInfoFinderTest.$getCallSiteArray();
        $callSiteArray = null;
    }

    static {
        Map map;
        LogInfoFinderTest.__$swapInit();
        Object object = LogInfoFinderTest.$getCallSiteArray()[66].call(LogInfoFinderTest.$getCallSiteArray()[67].call(LogInfoFinderTest.$getCallSiteArray()[68].call(LogInfoFinderTest.$getCallSiteArray()[69].call(LogInfoFinderTest.$getCallSiteArray()[70].call(LogInfoFinderTest.$getCallSiteArray()[71].call(LogInfoFinderTest.$getCallSiteArray()[72].call(LogInfoFinderTest.$getCallSiteArray()[73].call((Object)NODE_NAME_SAMPLE, (Object)" "), (Object)LOG_TIME_SAMPLE), (Object)" "), (Object)MONIT_LOG_LEVEL), (Object)" ["), (Object)LOGGER_NAME_SAMPLE), (Object)"] : "), (Object)LOG_DATA_SAMPLE);
        monitLogSample = (String)ScriptBytecodeAdapter.castToType((Object)object, String.class);
        emptyMap = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
    }

    public static final String getLogTemplate() {
        return logTemplate;
    }

    public static final String getNODE_NAME_SAMPLE() {
        return NODE_NAME_SAMPLE;
    }

    public static final String getLOG_TIME_SAMPLE() {
        return LOG_TIME_SAMPLE;
    }

    public static final String getMONIT_LOG_LEVEL() {
        return MONIT_LOG_LEVEL;
    }

    public static final String getLOGGER_NAME_SAMPLE() {
        return LOGGER_NAME_SAMPLE;
    }

    public static final String getLOG_DATA_SAMPLE() {
        return LOG_DATA_SAMPLE;
    }

    public static final String getMonitLogSample() {
        return monitLogSample;
    }

    public static final String getOtherLevelLogSample() {
        return otherLevelLogSample;
    }

    public static final String getProblematicLogSample() {
        return problematicLogSample;
    }

    public static final String getEmptyLog() {
        return emptyLog;
    }

    public static final Map<String, String> getEmptyMap() {
        return emptyMap;
    }

    public /* synthetic */ void this$2$testGetNodeName(String string, String string2) {
        this.testGetNodeName(string, string2);
    }

    public /* synthetic */ void this$2$testGetLogTime(String string, String string2) {
        this.testGetLogTime(string, string2);
    }

    public /* synthetic */ void this$2$testGetLogLevel(String string, String string2) {
        this.testGetLogLevel(string, string2);
    }

    public /* synthetic */ void this$2$testGetLoggerName(String string, String string2) {
        this.testGetLoggerName(string, string2);
    }

    public /* synthetic */ void this$2$testGetMonitLogData(String string, Map map) {
        this.testGetMonitLogData(string, map);
    }

    public /* synthetic */ void this$2$testGetLogData(String string, String string2) {
        this.testGetLogData(string, string2);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "assertTrue";
        stringArray[1] = "isValidMonitLogTrace";
        stringArray[2] = "assertFalse";
        stringArray[3] = "isValidMonitLogTrace";
        stringArray[4] = "assertFalse";
        stringArray[5] = "isValidMonitLogTrace";
        stringArray[6] = "assertFalse";
        stringArray[7] = "isValidMonitLogTrace";
        stringArray[8] = "assertFalse";
        stringArray[9] = "isValidMonitLogTrace";
        stringArray[10] = "assertTrue";
        stringArray[11] = "isValidLogTrace";
        stringArray[12] = "assertTrue";
        stringArray[13] = "isValidLogTrace";
        stringArray[14] = "assertTrue";
        stringArray[15] = "isValidLogTrace";
        stringArray[16] = "assertFalse";
        stringArray[17] = "isValidLogTrace";
        stringArray[18] = "assertFalse";
        stringArray[19] = "isValidLogTrace";
        stringArray[20] = "replaceFirst";
        stringArray[21] = "replaceFirst";
        stringArray[22] = "replaceFirst";
        stringArray[23] = "replaceFirst";
        stringArray[24] = "each";
        stringArray[25] = "testGetNodeName";
        stringArray[26] = "getNodeName";
        stringArray[27] = "assertEquals";
        stringArray[28] = "replaceFirst";
        stringArray[29] = "replaceFirst";
        stringArray[30] = "replaceFirst";
        stringArray[31] = "replaceFirst";
        stringArray[32] = "each";
        stringArray[33] = "testGetLogTime";
        stringArray[34] = "getLogTime";
        stringArray[35] = "assertEquals";
        stringArray[36] = "replaceFirst";
        stringArray[37] = "replaceFirst";
        stringArray[38] = "replaceFirst";
        stringArray[39] = "replaceFirst";
        stringArray[40] = "each";
        stringArray[41] = "testGetLogLevel";
        stringArray[42] = "getLogLevel";
        stringArray[43] = "assertEquals";
        stringArray[44] = "replaceFirst";
        stringArray[45] = "replaceFirst";
        stringArray[46] = "replaceFirst";
        stringArray[47] = "replaceFirst";
        stringArray[48] = "each";
        stringArray[49] = "testGetLoggerName";
        stringArray[50] = "getLoggerName";
        stringArray[51] = "assertEquals";
        stringArray[52] = "testGetMonitLogData";
        stringArray[53] = "getMonitLogData";
        stringArray[54] = "eachWithIndex";
        stringArray[55] = "newKeyIterator";
        stringArray[56] = "testGetMonitLogData";
        stringArray[57] = "testGetMonitLogData";
        stringArray[58] = "testGetMonitLogData";
        stringArray[59] = "getMonitLogData";
        stringArray[60] = "assertEquals";
        stringArray[61] = "testGetLogData";
        stringArray[62] = "testGetLogData";
        stringArray[63] = "testGetLogData";
        stringArray[64] = "getLogData";
        stringArray[65] = "assertEquals";
        stringArray[66] = "plus";
        stringArray[67] = "plus";
        stringArray[68] = "plus";
        stringArray[69] = "plus";
        stringArray[70] = "plus";
        stringArray[71] = "plus";
        stringArray[72] = "plus";
        stringArray[73] = "plus";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[74];
        LogInfoFinderTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(LogInfoFinderTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LogInfoFinderTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

