/****************************************************************************
 *
 * Copyright (c) 2011-2012, EBM WebSourcing
 * This code is not made public and should not be shared outside EBM WebSourcing. 
 *
 *****************************************************************************/

package org.ow2.petals.components.steps;
import javax.xml.namespace.QName

import org.jbehave.core.annotations.AfterScenario
import org.jbehave.core.annotations.Alias
import org.jbehave.core.annotations.ScenarioType
import org.jbehave.core.annotations.Then
import org.jbehave.core.model.ExamplesTable
import org.ow2.petals.commons.log.Level
import org.ow2.petals.commons.log.PetalsExecutionContext
import org.ow2.petals.component.api.ServiceConfiguration
import org.ow2.petals.components.stories.partner.PInterfaceName1Impl
import org.ow2.petals.components.stories.util.LogInfoFinder

import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType
import com.ebmwebsourcing.jbi.adaptor.impl.JbiConstants


public class AbstractComponentWithJsr181PartnerSteps extends AbstractComponentSteps {


    @AfterScenario(uponType=ScenarioType.EXAMPLE)
    def stopJsr181Component() {
        if ((this.jsr181Component != null) && jsr181Component.isStarted()) {
            this.jsr181Component.uninstallAllServices();
            this.jsr181Component.stop();
            this.jsr181Component = null;
        }
    }


    protected doBindJsr181JavaMethodExecutionAsService(String provideJsr181InterfaceName, String provideJsr181ServiceName, String provideJsr181EndpointName, String provideJsr181OperationName, String componentName) {
        this.provideJsr181InterfaceName = provideJsr181InterfaceName;
        this.provideJsr181ServiceName = provideJsr181ServiceName;
        this.provideJsr181EndpointName = provideJsr181EndpointName;
        this.provideJsr181OperationName = provideJsr181OperationName;

        this.jsr181Component = createAndStartComponent(ComponentType.SE_JSR181, createComponentConfiguration(componentName));
        ServiceConfiguration.ServiceType role = ServiceConfiguration.ServiceType.PROVIDE;

        def wsdlName = "jsr181.wsdl"
        URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource(wsdlName);
        assert wsdlUrl != null;

        this.provideJsr181ServiceConfiguration = new ServiceConfiguration("AbstractOrchestratorComponent",QName.valueOf(provideJsr181InterfaceName),QName.valueOf(provideJsr181ServiceName), provideJsr181EndpointName, role);
        this.provideJsr181ServiceConfiguration.setParameter("{http://petals.ow2.org/components/jsr181/version-1}class", PInterfaceName1Impl.class.getName());
        this.provideJsr181ServiceConfiguration.setParameter("{"+ JbiConstants.CDK_NAMESPACE_URI +"}wsdl", wsdlName);
        this.provideJsr181ServiceConfiguration.addResource(wsdlUrl);
        this.jsr181Component.installService(this.provideJsr181ServiceConfiguration)
    }


    @Then("""after first record, an other MONIT record, known as second record, is logged on <nodeName> by <providerComponentName> containing strictly following info in this order:\$logDataTable""")
    @Alias("""later, a second MONIT record is logged on <nodeName> by <providerComponentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterASecondMONITRecordIsLoggedOnNodeNameByProviderComponentNameContainingStrictlyFollowingInfoInThisOrder(
            String nodeName,
            String providerComponentName,
            ExamplesTable logDataTable) {
        super.thenLaterASecondMONITRecordIsLoggedOnNodeNameByComponentNameContainingStrictlyFollowingInfoInThisOrder(nodeName, providerComponentName, logDataTable);
    }

    @Then("""after first record, an other MONIT record, known as second record, is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:\$logDataTable""")
    @Alias("""later, a second MONIT record is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterASecondMONITRecordIsLoggedOnNodeNameByPartnerComponentNameContainingStrictlyFollowingInfoInThisOrder(
            String nodeName,
            String partnerComponentName,
            ExamplesTable logDataTable) {
        super.thenLaterASecondMONITRecordIsLoggedOnNodeNameByComponentNameContainingStrictlyFollowingInfoInThisOrder(nodeName, partnerComponentName, logDataTable);
    }

    @Then("""after second record, an other MONIT record, known as third record, is logged on <nodeName> by <providerComponentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterAThirdMONITRecordIsLoggedOnNodeNameByProvidercomponentNameContainingStrictlyFollowingInfoInThisOrder(
            String nodeName,
            String providerComponentName,
            ExamplesTable logDataTable) {
        this.logEntries[2] = checkCurrentLogEntry(nodeName, providerComponentName, Level.MONIT, logDataTable, this.logEntries[1]);
    }

    @Then("""after second record, an other MONIT record, known as third record, is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterAThirdMONITRecordIsLoggedOnNodeNameByPartnercomponentNameContainingStrictlyFollowingInfoInThisOrder(
            String nodeName,
            String partnerComponentName,
            ExamplesTable logDataTable) {
        this.thenLaterAThirdMONITRecordIsLoggedOnNodeNameByProvidercomponentNameContainingStrictlyFollowingInfoInThisOrder(nodeName, partnerComponentName, logDataTable);
    }

    @Then("""after first record, an other MONIT record, known as fourth record, is logged on <nodeName> by <componentName> containing strictly following info in this order:\$logDataTable""")
    public void thenAfterFirstRecordAFourthMONITRecordIsLoggedOnNodeNameByComponentNameContainingStrictlyFollowingInfoInThisOrder(
            String nodeName,
            String componentName,
            ExamplesTable logDataTable) {
        this.logEntries[3] = checkCurrentLogEntry(nodeName, componentName, Level.MONIT, logDataTable, this.logEntries[0]);
    }

    @Then("""after second record, an other MONIT record, known as fourth record, is logged on <nodeName> by <componentName> containing strictly following info in this order:\$logDataTable""")
    public void thenAfterSecondRecordAFourthMONITRecordIsLoggedOnNodeNameByComponentNameContainingStrictlyFollowingInfoInThisOrder(
            String nodeName,
            String componentName,
            ExamplesTable logDataTable) {
        this.logEntries[3] = checkCurrentLogEntry(nodeName, componentName, Level.MONIT, logDataTable, this.logEntries[1]);
    }

    @Then("""later, a third MONIT record is logged on <nodeName> by <providerComponentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterAThirdMONITRecordIsLoggedOnNodeNameByProviderComponentNameContainingStrictlyFollowingInfoInThisOrder(
            String nodeName,
            String providerComponentName,
            ExamplesTable logDataTable) {
        this.logEntries[2] = checkCurrentLogEntry(nodeName, providerComponentName, Level.MONIT, logDataTable, this.logEntries[1]);
    }

    @Then("""later, a third MONIT record is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterAThirdMONITRecordIsLoggedOnNodeNameByPartnerComponentNameContainingStrictlyFollowingInfoInThisOrder(
            String nodeName,
            String partnerComponentName,
            ExamplesTable logDataTable) {
        this.thenLaterAThirdMONITRecordIsLoggedOnNodeNameByProviderComponentNameContainingStrictlyFollowingInfoInThisOrder(nodeName, partnerComponentName, logDataTable);
    }

    @Then("flowStepId of first record must be equal to flowStepId of fourth record")
    public void thenFlowStepIdOfFirstRecordMustBeEqualToFlowStepIdOfFourthRecord(){
        assertSameFlowStepId(this.logEntries[0], this.logEntries[3]);
    }

    @Then("flowStepId of second record must be equal to flowStepId of third record")
    public void thenFlowStepIdOfSecondRecordMustBeEqualToFlowStepIdOfThirdRecord(){
        assertSameFlowStepId(this.logEntries[2], this.logEntries[1]);
    }

    @Then("flowInstanceId of first and second records must be the same")
    public void thenFlowInstanceIdOfFirstAndSecondRecordsMustBeTheSame(){
        assertSameFlowInstanceId(this.logEntries[0], this.logEntries[1]);
    }

    @Then("flowPreviousStepId of second record must be equal to flowStepId of first record")
    public void thenFlowPreviousStepIdOfSecondRecordMustBeEqualToFlowStepIdOfFirstRecord(){
        String flowPreviousStepIdOfSecondRecord =
                LogInfoFinder.getMonitLogData(this.logEntries[1]).get(PetalsExecutionContext.FLOW_PREVIOUS_STEP_ID_PROPERTY_NAME);
        String flowStepIdOfFirstRecord =
                LogInfoFinder.getMonitLogData(this.logEntries[0]).get(PetalsExecutionContext.FLOW_STEP_ID_PROPERTY_NAME);
        assert flowPreviousStepIdOfSecondRecord.equals(flowStepIdOfFirstRecord);
    }
}

