/****************************************************************************
 *
 * Copyright (c) 2011-2012, EBM WebSourcing
 * This code is not made public and should not be shared outside EBM WebSourcing. 
 *
 *****************************************************************************/

package org.ow2.petals.components.stories.util

import com.ebmwebsourcing.easycommons.thread.InheritableThreadContext

class StoryContext {

    protected StoryContext() {
    }

    public final void reset() {
        InheritableThreadContext.reset();
    }

    def propertyMissing(String propertyName) {
        return InheritableThreadContext.getParameters().getValueOrDefault(propertyName);
    }


    void setProperty(String propertyName, Object propertyValue) {
        if (propertyValue!=null){
            InheritableThreadContext.getParameters().put(propertyName, propertyValue);
        }
        else{
            InheritableThreadContext.getParameters().remove(propertyName);
        }
    }
}
