package org.ow2.petals.components.stories.util;

import org.junit.Test;
import org.ow2.petals.components.stories.util.RegexMatcher;

import static org.junit.Assert.*;

/**
 * @author aruffie
 *
 */
public class RegexMatcherTest {

    def final String regexPattern = "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}";
    
    @Test
    public void testMatchesOkWithCorrectRegexValue() {
        RegexMatcher regexMatcher = new RegexMatcher(regexPattern);
        assertTrue(regexMatcher.matchesSafely("f586fc9b-b374-0021-6a65-569e8a3401db"));
    }
    
    @Test
    public void testMatchesNotOkWithIncorrectRegexValue() {
        RegexMatcher regexMatcher = new RegexMatcher(regexPattern);
        assertFalse(regexMatcher.matchesSafely("f586f9b-b34-021-a65-569e8a3401"));
        assertFalse(regexMatcher.matchesSafely("f586-f9b-b-34-021-a65-56-9e8-a3401"));
        assertFalse(regexMatcher.matchesSafely(""));
        assertFalse(regexMatcher.matchesSafely("*f586f9b-b34-021-a65-569e8a3401*"));
        assertFalse(regexMatcher.matchesSafely("*"));
        assertFalse(regexMatcher.matchesSafely("/~*"));
    }
}
