package org.ow2.petals.components.stories.util

import static org.junit.Assert.*

import org.junit.Before;
import org.junit.Test;

import static StoryContext.*;

class StoryContextTest {

    @Before
    public void before() {
    }
    

    @Test
    public void testGetNullProperty() {
        StoryContext storyContext = new StoryContext();
        assertNull(storyContext.unknown);
    }
    
    @Test
    public void testPutGetProperty() {
        StoryContext storyContext = new StoryContext();
        storyContext.testProperty1 = "testValue1";
        assertEquals("testValue1", storyContext.testProperty1);
    }

    @Test
    public void testGetNullPropertyAfterReset() {
        StoryContext storyContext = new StoryContext();
        storyContext.testProperty1 = "oldTestValue1";
        assertEquals("oldTestValue1", storyContext.testProperty1);
        storyContext.reset();
        assertNull(storyContext.testProperty1);
    }

    @Test
    public void testPutAndGetPropertyAfterReset() {
        StoryContext storyContext = new StoryContext();
        storyContext.testProperty1 = "oldTestValue1";
        assertEquals("oldTestValue1", storyContext.testProperty1);
        storyContext.reset();
        storyContext.testProperty1 = "testValue1";
        assertEquals("testValue1", storyContext.testProperty1);
    }
    
    @Test
    public void testGetWellKnownProperty() {
        StoryContext storyContext = new StoryContext();
        assertSame(StoryContext.class, storyContext.class);
    }
    
    @Test
    public void testGetStaticFieldOnChildClass() {
        assertEquals("staticValue", StoryContextChildClass.STATIC_CONSTANT);
    }
    
    @Test
    public void testGetFieldOnChildClass() {
        StoryContext storyContext = new StoryContextChildClass();
        assertEquals("fieldValue", storyContext.fieldConstant);
    }
    

    private static class StoryContextChildClass extends StoryContext {
        
        private static final STATIC_CONSTANT = "staticValue";
        private final fieldConstant = "fieldValue";
        
        StoryContextChildClass() {
            
        }
    } 
    
}

