/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.components.stories;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.io.UnderscoredCamelCaseResolver;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.MarkUnmatchedStepsAsPending;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCollector;

final class PerStoryStepCollector
extends MarkUnmatchedStepsAsPending {
    private static final String BEFORE_AND_AFTER_STEPS_CLASSNAME = "BeforeAndAfterSteps";
    private Package runningStoriesPackage;
    private Story currentStory;

    public PerStoryStepCollector(Package runningStoriesPackage) {
        this.runningStoriesPackage = runningStoriesPackage;
        this.currentStory = null;
    }

    public List<Step> collectBeforeOrAfterScenarioSteps(List<CandidateSteps> candidateStepsList, Meta meta, StepCollector.Stage stage, ScenarioType scenarioType) {
        List steps = super.collectBeforeOrAfterScenarioSteps(this.filterIrrelevantCandidateSteps(candidateStepsList, true, true), meta, stage, scenarioType);
        return steps;
    }

    private List<CandidateSteps> filterIrrelevantCandidateSteps(List<CandidateSteps> candidateStepsList, boolean considerBeforeAndAfterSteps, boolean considerStorySteps) {
        ArrayList<CandidateSteps> filteredCandidateSteps = new ArrayList<CandidateSteps>();
        for (CandidateSteps candidateSteps : candidateStepsList) {
            List stepCandidates = candidateSteps.listCandidates();
            if (stepCandidates.isEmpty()) continue;
            StepCandidate stepCandidate = (StepCandidate)stepCandidates.get(0);
            if ((!considerBeforeAndAfterSteps || !this.isContainedInBeforeAndAfterStepsClass(stepCandidate)) && (!considerStorySteps || !this.isContainedInCurrentStoryStepsClass(stepCandidate))) continue;
            filteredCandidateSteps.add(candidateSteps);
        }
        return filteredCandidateSteps;
    }

    private boolean isContainedInCurrentStoryStepsClass(StepCandidate stepCandidate) {
        assert (this.currentStory != null);
        Class<?> stepsClass = stepCandidate.getStepsInstance().getClass();
        if (!this.runningStoriesPackage.getName().equals(stepsClass.getPackage().getName().replaceAll("\\.steps", "\\.stories"))) {
            return false;
        }
        UnderscoredCamelCaseResolver resolver = new UnderscoredCamelCaseResolver();
        String storyName = resolver.resolve(stepsClass);
        return (storyName = storyName.substring(storyName.lastIndexOf(47) + 1).replaceAll("_steps\\.", "\\.")).equals(this.currentStory.getName());
    }

    private boolean isContainedInBeforeAndAfterStepsClass(StepCandidate stepCandidate) {
        Class<?> stepsClass = stepCandidate.getStepsInstance().getClass();
        if (!BEFORE_AND_AFTER_STEPS_CLASSNAME.equals(stepsClass.getSimpleName())) {
            return false;
        }
        return this.runningStoriesPackage.getName().equals(stepsClass.getPackage().getName().replaceAll("\\.steps", "\\.stories"));
    }

    public List<Step> collectBeforeOrAfterStoriesSteps(List<CandidateSteps> candidateStepsList, StepCollector.Stage stage) {
        List<CandidateSteps> filteredCandidateStepsList = this.filterIrrelevantCandidateSteps(candidateStepsList, true, false);
        List steps = super.collectBeforeOrAfterStoriesSteps(filteredCandidateStepsList, stage);
        return steps;
    }

    public List<Step> collectBeforeOrAfterStorySteps(List<CandidateSteps> candidateStepsList, Story story, StepCollector.Stage stage, boolean givenStory) {
        this.currentStory = story;
        List steps = super.collectBeforeOrAfterStorySteps(this.filterIrrelevantCandidateSteps(candidateStepsList, true, true), story, stage, givenStory);
        return steps;
    }

    public List<Step> collectScenarioSteps(List<CandidateSteps> candidateStepsList, Scenario scenario, Map<String, String> parameters) {
        List<CandidateSteps> filteredCandidateStepsList = this.filterIrrelevantCandidateSteps(candidateStepsList, false, true);
        List steps = super.collectScenarioSteps(filteredCandidateStepsList, scenario, parameters);
        return steps;
    }
}

