package org.ow2.petals.components.steps;

import static org.junit.Assert.assertFalse

import java.net.URL

import javax.xml.namespace.QName

import org.jbehave.core.annotations.AfterScenario
import org.jbehave.core.annotations.Alias
import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named
import org.jbehave.core.annotations.ScenarioType
import org.jbehave.core.annotations.Then
import org.jbehave.core.model.ExamplesTable
import org.ow2.petals.commons.logger.AbstractFlowLogData
import org.ow2.petals.commons.logger.ProvideFlowStepBeginLogData
import org.ow2.petals.component.api.ServiceConfiguration
import org.ow2.petals.components.stories.partner.PInterfaceName1Impl
import org.ow2.petals.components.stories.util.LogInfoFinder

import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType
import com.ebmwebsourcing.jbi.adaptor.impl.JbiConstants


public class AbstractOrchestratorComponentSteps extends AbstractComponentSteps {

	@AfterScenario(uponType=ScenarioType.EXAMPLE)
	def stop() {
		super.stop();
		if(this.jsr181Component != null && this.jsr181Component.isStarted()) {
			this.jsr181Component.uninstallAllServices();
			this.jsr181Component.stop();
		}
	}
	
    @Given("""a jsr-181 component <providerComponentName> configured on <nodeName>
	so that operation <providerOperationName> of internal service
	<providerInterfaceName>,<providerServiceName>,<providerEndpointName> is bound to java method execution""")
    def boundJsr181ProviderJavaMethodExcecutionAsService(@Named("providerComponentName") String providerComponentName,
    @Named("nodeName") String nodeName, @Named("providerOperationName") String providerOperationName,
    @Named("providerInterfaceName") String providerInterfaceName, @Named("providerServiceName") String providerServiceName,
    @Named("providerEndpointName") String providerEndpointName) {
        boundJsr181JavaMethodExecutionAsService(providerInterfaceName, providerServiceName, providerEndpointName, providerOperationName, providerComponentName);
    }

    @Given("""a jsr-181 component <partnerComponentName> configured on <nodeName>
	so that operation <partnerOperationName> of internal service
	<partnerInterfaceName>,<partnerServiceName>,<partnerEndpointName> is bound to java method execution""")
    def boundJsr181PartnerJavaMethodExcecutionAsService(@Named("partnerComponentName") String partnerComponentName,
    @Named("nodeName") String nodeName, @Named("partnerOperationName") String partnerOperationName,
    @Named("partnerInterfaceName") String partnerInterfaceName, @Named("partnerServiceName") String partnerServiceName,
    @Named("partnerEndpointName") String partnerEndpointName) {
        boundJsr181JavaMethodExecutionAsService(partnerInterfaceName, partnerServiceName, partnerEndpointName, partnerOperationName, partnerComponentName);
    }

    protected boundJsr181JavaMethodExecutionAsService(String provideJsr181InterfaceName, String provideJsr181ServiceName, String provideJsr181EndpointName, String provideJsr181OperationName, String componentName) {
        this.provideJsr181InterfaceName = provideJsr181InterfaceName;
        this.provideJsr181ServiceName = provideJsr181ServiceName;
        this.provideJsr181EndpointName = provideJsr181EndpointName;
        this.provideJsr181OperationName = provideJsr181OperationName;

        this.jsr181Component = createAndStartComponent(ComponentType.SE_JSR181, createComponentConfiguration(componentName));
        ServiceConfiguration.ServiceType role = ServiceConfiguration.ServiceType.PROVIDE;

        def wsdlName = "jsr181.wsdl"
        URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource(wsdlName);
        assert wsdlUrl != null;

        this.provideJsr181ServiceConfiguration = new ServiceConfiguration("AbstractOrchestratorComponent",QName.valueOf(provideJsr181InterfaceName),QName.valueOf(provideJsr181ServiceName), provideJsr181EndpointName, role);
        this.provideJsr181ServiceConfiguration.setParameter("{http://petals.ow2.org/components/jsr181/version-1}class", PInterfaceName1Impl.class.getName());
        this.provideJsr181ServiceConfiguration.setParameter("{"+ JbiConstants.CDK_NAMESPACE_URI +"}wsdl", wsdlName);
        this.provideJsr181ServiceConfiguration.addResource(wsdlUrl);
        this.jsr181Component.installService(this.provideJsr181ServiceConfiguration)
    }

    @Then("""after first record, an other MONIT record, known as second record, is logged on <nodeName> by <providerComponentName> containing strictly following info in this order:\$logDataTable""")
    @Alias("""later, a second MONIT record is logged on <nodeName> by <providerComponentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterASecondMONITRecordIsLoggedOnNodeNameByProviderComponentNameContainingStrictlyFollowingInfoInThisOrder(
    @Named("nodeName") String nodeName,
    @Named("providerComponentName") String providerComponentName,
    @Named("logDataTable") ExamplesTable logDataTable) {
        this.secondLogEntry = checkCurrentLogEntry(nodeName, providerComponentName, logDataTable, firstLogEntry);
    }

    @Then("""after first record, an other MONIT record, known as second record, is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:\$logDataTable""")
    @Alias("""later, a second MONIT record is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterASecondMONITRecordIsLoggedOnNodeNameByPartnerComponentNameContainingStrictlyFollowingInfoInThisOrder(
    @Named("nodeName") String nodeName,
    @Named("partnerComponentName") String partnerComponentName,
    @Named("logDataTable") ExamplesTable logDataTable) {
        this.thenLaterASecondMONITRecordIsLoggedOnNodeNameByProviderComponentNameContainingStrictlyFollowingInfoInThisOrder(nodeName, partnerComponentName, logDataTable);
    }

    @Then("""after second record, an other MONIT record, known as third record, is logged on <nodeName> by <providerComponentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterAThirdMONITRecordIsLoggedOnNodeNameByProvidercomponentNameContainingStrictlyFollowingInfoInThisOrder(
    @Named("nodeName") String nodeName,
    @Named("providerComponentName") String providerComponentName,
    @Named("logDataTable") ExamplesTable logDataTable) {
        this.thirdLogEntry = checkCurrentLogEntry(nodeName, providerComponentName, logDataTable, secondLogEntry);
    }

    @Then("""after second record, an other MONIT record, known as third record, is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterAThirdMONITRecordIsLoggedOnNodeNameByPartnercomponentNameContainingStrictlyFollowingInfoInThisOrder(
    @Named("nodeName") String nodeName,
    @Named("partnerComponentName") String partnerComponentName,
    @Named("logDataTable") ExamplesTable logDataTable) {
        this.thenLaterAThirdMONITRecordIsLoggedOnNodeNameByProvidercomponentNameContainingStrictlyFollowingInfoInThisOrder(nodeName, partnerComponentName, logDataTable);
    }

    @Then("""after first record, an other MONIT record, known as fourth record, is logged on <nodeName> by <componentName> containing strictly following info in this order:\$logDataTable""")
    public void thenAfterFirstRecordAFourthMONITRecordIsLoggedOnNodeNameByComponentNameContainingStrictlyFollowingInfoInThisOrder(
    @Named("nodeName") String nodeName,
    @Named("componentName") String componentName,
    @Named("logDataTable") ExamplesTable logDataTable) {
        this.fourthLogEntry = checkCurrentLogEntry(nodeName, componentName, logDataTable, firstLogEntry);
    }

    @Then("""after second record, an other MONIT record, known as fourth record, is logged on <nodeName> by <componentName> containing strictly following info in this order:\$logDataTable""")
    public void thenAfterSecondRecordAFourthMONITRecordIsLoggedOnNodeNameByComponentNameContainingStrictlyFollowingInfoInThisOrder(
    @Named("nodeName") String nodeName,
    @Named("componentName") String componentName,
    @Named("logDataTable") ExamplesTable logDataTable) {
        this.fourthLogEntry = checkCurrentLogEntry(nodeName, componentName, logDataTable, secondLogEntry);
    }

    @Then("""later, a fourth MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterAFourthMONITRecordIsLoggedOnNodeNameByComponentNameContainingStrictlyFollowingInfoInThisOrder(
    @Named("nodeName") String nodeName,
    @Named("componentName") String componentName,
    @Named("logDataTable") ExamplesTable logDataTable) {
        this.fourthLogEntry = checkCurrentLogEntry(nodeName, componentName, logDataTable, thirdLogEntry);
    }

    @Then("""later, a third MONIT record is logged on <nodeName> by <providerComponentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterAThirdMONITRecordIsLoggedOnNodeNameByProviderComponentNameContainingStrictlyFollowingInfoInThisOrder(
    @Named("nodeName") String nodeName,
    @Named("providerComponentName") String providerComponentName,
    @Named("logDataTable") ExamplesTable logDataTable) {
        this.thirdLogEntry = checkCurrentLogEntry(nodeName, providerComponentName, logDataTable, secondLogEntry);
    }

    @Then("""later, a third MONIT record is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:\$logDataTable""")
    public void thenLaterAThirdMONITRecordIsLoggedOnNodeNameByPartnerComponentNameContainingStrictlyFollowingInfoInThisOrder(
    @Named("nodeName") String nodeName,
    @Named("partnerComponentName") String partnerComponentName,
    @Named("logDataTable") ExamplesTable logDataTable) {
        this.thenLaterAThirdMONITRecordIsLoggedOnNodeNameByProviderComponentNameContainingStrictlyFollowingInfoInThisOrder(nodeName, partnerComponentName, logDataTable);
    }

    @Then("flowStepId of first record must be equal to flowStepId of fourth record")
    public void thenFlowStepIdOfFirstRecordMustBeEqualToFlowStepIdOfFourthRecord(){
        String flowStepIdOfFirstRecord =
                LogInfoFinder.getMonitLogData(firstLogEntry).get(AbstractFlowLogData.FLOW_STEP_ID_PROPERTY_NAME);
        String flowStepIdOfFourthRecord =
                LogInfoFinder.getMonitLogData(fourthLogEntry).get(AbstractFlowLogData.FLOW_STEP_ID_PROPERTY_NAME);
        assert flowStepIdOfFirstRecord.equals(flowStepIdOfFourthRecord);
    }

    @Then("flowStepId of second record must be equal to flowStepId of third record")
    public void thenFlowStepIdOfSecondRecordMustBeEqualToFlowStepIdOfThirdRecord(){
        String flowStepIdOfSecondRecord =
                LogInfoFinder.getMonitLogData(secondLogEntry).get(AbstractFlowLogData.FLOW_STEP_ID_PROPERTY_NAME);
        String flowStepIdOfThirdRecord =
                LogInfoFinder.getMonitLogData(thirdLogEntry).get(AbstractFlowLogData.FLOW_STEP_ID_PROPERTY_NAME);
        assert flowStepIdOfSecondRecord.equals(flowStepIdOfThirdRecord);
    }

    @Then("flowInstanceId of all records must be the same")
    public void thenFlowInstanceIdOfAllRecordsMustBeTheSame(){
        String flowInstanceIdOfFirstRecord =
                LogInfoFinder.getMonitLogData(firstLogEntry).get(AbstractFlowLogData.FLOW_INSTANCE_ID_PROPERTY_NAME);
        String flowInstanceIdOfSecondRecord =
                LogInfoFinder.getMonitLogData(secondLogEntry).get(AbstractFlowLogData.FLOW_INSTANCE_ID_PROPERTY_NAME);
        String flowInstanceIdOfThirdRecord =
                LogInfoFinder.getMonitLogData(thirdLogEntry).get(AbstractFlowLogData.FLOW_INSTANCE_ID_PROPERTY_NAME);
        String flowInstanceIdOfFourthRecord =
                LogInfoFinder.getMonitLogData(fourthLogEntry).get(AbstractFlowLogData.FLOW_INSTANCE_ID_PROPERTY_NAME);
        assert flowInstanceIdOfFirstRecord.equals(flowInstanceIdOfSecondRecord);
        assert flowInstanceIdOfFirstRecord.equals(flowInstanceIdOfThirdRecord);
        assert flowInstanceIdOfFirstRecord.equals(flowInstanceIdOfFourthRecord);
    }

    @Then("flowPreviousStepId of second record must be equal to flowStepId of first record")
    public void thenFlowPreviousStepIdOfSecondRecordMustBeEqualToFlowStepIdOfFirstRecord(){
        String flowPreviousStepIdOfSecondRecord =
                LogInfoFinder.getMonitLogData(secondLogEntry).get(ProvideFlowStepBeginLogData.FLOW_PREVIOUS_STEP_ID_PROPERTY_NAME);
        String flowStepIdOfFirstRecord =
                LogInfoFinder.getMonitLogData(firstLogEntry).get(AbstractFlowLogData.FLOW_STEP_ID_PROPERTY_NAME);
        assert flowPreviousStepIdOfSecondRecord.equals(flowStepIdOfFirstRecord);
    }
}

