package org.ow2.petals.components.stories.util

import org.codehaus.groovy.classgen.ReturnAdder;

class LogInfoFinder {

    def static logPattern = ~/^(\w*)\s(\d*\/\d*\/\d*\s\d*:\d*:\d*,\d*\sGMT[\+\-]\d*)\s(\w*)\s\[(.*)\]\s:\s(.*)/

    def static monitLogPattern = ~/^(\w*)\s(\d*\/\d*\/\d*\s\d*:\d*:\d*,\d*\sGMT[\+\-]\d*)\s(MONIT)\s\[(.*)\]\s:\s(\w*\s=\s'.*'[,]?)*$/

    public static String getNodeName(String logString){
        assert isValidLogTrace(logString)
        return logPattern.matcher(logString)[0][1]
    }

    public static String getLogTime(String logString){
        assert isValidLogTrace(logString)
        return logPattern.matcher(logString)[0][2]
    }

    public static String getLogLevel(String logString){
        assert isValidLogTrace(logString)
        return logPattern.matcher(logString)[0][3]
    }

    public static String getLoggerName(String logString){
        assert isValidLogTrace(logString)
        return logPattern.matcher(logString)[0][4]
    }

    public static String getLogData(String logString){
        assert isValidLogTrace(logString)
        return logPattern.matcher(logString)[0][5]
    }

    public static LinkedHashMap<String, String> getMonitLogData(String logString){
        def monitLogData = [:]
        if (isValidMonitLogTrace(logString)){
            monitLogPattern.matcher(logString)[0][5].split(",").each {
                monitLogData.put(it.split("=")[0].trim(), it.split("=")[1].trim().replace("'", ""))
            };
        }
        return monitLogData
    }

    static isValidMonitLogTrace(String logString){
        return logString!=null && !"".equals(logString) && logString.matches(monitLogPattern)
    }

    static isValidLogTrace(String logString){
        return logString!=null && !"".equals(logString) && logString.matches(logPattern)
    }
}
