package org.ow2.petals.components.stories.util;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexMatcher extends TypeSafeMatcher<String> {

    final String regexPattern;

    public RegexMatcher(String regexPattern) {
        this.regexPattern = regexPattern
    }

    @Override
    public void describeTo(Description description) {
        description.appendValue(this.regexPattern);
    }

    @Override
    public boolean matchesSafely(String regexValue) {
        Pattern pattern = Pattern.compile("^" + this.regexPattern + "\$")
        return pattern.matcher(regexValue).matches()
    }
}
