package org.ow2.petals.components.stories.util

import static org.junit.Assert.*

import com.ebmwebsourcing.easycommons.thread.InheritableThreadContext;

class StoryContext {

    protected StoryContext() {
    }

    public final void reset() {
        InheritableThreadContext.reset();
    }
    
    def propertyMissing(String propertyName) {
        return InheritableThreadContext.getParameters().getValueOrDefault(propertyName);
    }


    void setProperty(String propertyName, Object propertyValue) {
        InheritableThreadContext.getParameters().put(propertyName, propertyValue);
    }
}
